/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.autoconfigurer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.util.DefaultInstantiatorStrategy;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.xforceplus.ultraman.config.ConfigConverter;
import com.xforceplus.ultraman.config.ConfigurationEngine;
import com.xforceplus.ultraman.config.EventStrategy;
import com.xforceplus.ultraman.config.event.ChangeList;
import com.xforceplus.ultraman.config.json.JsonConfigNode;
import com.xforceplus.ultraman.config.storage.ConfigurationStorage;
import com.xforceplus.ultraman.config.storage.impl.DefaultFileConfigurationStorage;
import com.xforceplus.ultraman.config.storage.impl.DefaultInMemoryConfigurationStorage;
import com.xforceplus.ultraman.config.strategy.DiscardStrategy;
import com.xforceplus.ultraman.config.strategy.VersiondDiscardStrategy;
import com.xforceplus.ultraman.config.strategy.impl.DefaultJsonEventStrategy;
import com.xforceplus.ultraman.metadata.grpc.DictUpResult;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.oqsengine.pojo.dto.UltForm;
import com.xforceplus.ultraman.oqsengine.pojo.dto.UltPage;
import com.xforceplus.ultraman.oqsengine.sdk.autoconfigurer.GlobalInited;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.config.engine.VersionedJsonConfig;
import com.xforceplus.ultraman.oqsengine.sdk.config.init.ConfigType;
import com.xforceplus.ultraman.oqsengine.sdk.event.config.ConfigChangeEvent;
import com.xforceplus.ultraman.oqsengine.sdk.listener.ConfigListener;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"xplat.oqsengine.sdk.enabled"}, matchIfMissing=true)
@Configuration
public class RuntimeConfigAutoConfiguration {
    private Logger logger = LoggerFactory.getLogger(RuntimeConfigAutoConfiguration.class);

    @ConditionalOnMissingBean(value={Kryo.class})
    @Bean
    public Kryo kryo() {
        Kryo kryo = new Kryo();
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        kryo.setRegistrationRequired(false);
        return kryo;
    }

    @ConditionalOnMissingBean(value={EventStrategy.class})
    @Bean
    public EventStrategy jsonJsonEventStrategy() {
        return new DefaultJsonEventStrategy();
    }

    @ConditionalOnMissingBean(value={DiscardStrategy.class})
    @Bean
    public DiscardStrategy discardStrategy() {
        return new VersiondDiscardStrategy();
    }

    @ConditionalOnMissingBean(value={ObjectMapper.class})
    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    @ConditionalOnMissingBean(value={ConfigurationStorage.class})
    @ConditionalOnProperty(value={"xplat.oqsengine.sdk.config.mem.enabled"}, matchIfMissing=true)
    @ConditionalOnBean(value={EventStrategy.class, DiscardStrategy.class})
    @Bean
    public ConfigurationStorage memStorage(EventStrategy eventStratregy, DiscardStrategy discardStrategy) {
        DefaultInMemoryConfigurationStorage memStorage = new DefaultInMemoryConfigurationStorage(eventStratregy, discardStrategy);
        return memStorage;
    }

    @ConditionalOnMissingBean(value={ConfigurationStorage.class})
    @ConditionalOnProperty(value={"xplat.oqsengine.sdk.config.file.enabled"}, matchIfMissing=false)
    @ConditionalOnBean(value={EventStrategy.class, DiscardStrategy.class})
    @Bean
    public ConfigurationStorage fileStorage(@Value(value="${xplat.oqsengine.sdk.config.file.root:/}") String root, Kryo kryo, EventStrategy eventStratregy, DiscardStrategy discardStrategy) {
        DefaultFileConfigurationStorage fileStorage = new DefaultFileConfigurationStorage(root, kryo, eventStratregy, discardStrategy);
        return fileStorage;
    }

    @Bean(value={"moduleConfigEngine"})
    public ConfigurationEngine<ModuleUpResult, JsonConfigNode> engineForModule(ConfigurationStorage storage, ObjectMapper mapper) {
        ConfigurationEngine engine = new ConfigurationEngine();
        engine.setConfigurationStorage(storage);
        ConfigConverter converter = customConfig -> {
            try {
                String json = JsonFormat.printer().print((MessageOrBuilder)customConfig);
                return new VersionedJsonConfig(customConfig.getVersion(), ConfigType.BO.name(), "" + customConfig.getId(), mapper.readTree(json), null);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        };
        engine.setConverter(converter);
        return engine;
    }

    @Bean(value={"dictConfigEngine"})
    public ConfigurationEngine<DictUpResult, JsonConfigNode> engineForDict(ConfigurationStorage storage, ObjectMapper mapper, AuthSearcherConfig config) {
        ConfigurationEngine engine = new ConfigurationEngine();
        engine.setConfigurationStorage(storage);
        ConfigConverter converter = customConfig -> {
            try {
                String json = JsonFormat.printer().print((MessageOrBuilder)customConfig);
                if (!customConfig.getDictsList().isEmpty()) {
                    return new VersionedJsonConfig(customConfig.getDicts(0).getVersion(), ConfigType.DICT.name(), config.getAppId(), mapper.readTree(json), null);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return null;
        };
        engine.setConverter(converter);
        return engine;
    }

    @Bean(value={"formConfigEngine"})
    public ConfigurationEngine<UltForm, JsonConfigNode> engineForForm(ConfigurationStorage storage, ObjectMapper mapper) {
        ConfigurationEngine engine = new ConfigurationEngine();
        engine.setConfigurationStorage(storage);
        ConfigConverter converter = form -> {
            try {
                return new VersionedJsonConfig(form.getVersion(), ConfigType.FORM.name(), "" + form.getId(), mapper.valueToTree(form), null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        };
        engine.setConverter(converter);
        return engine;
    }

    @ConditionalOnBean(value={Kryo.class, ConfigurationStorage.class})
    @Bean(value={"pageConfigEngine"})
    public ConfigurationEngine<UltPage, JsonConfigNode> engineForPage(ConfigurationStorage storage, ObjectMapper mapper) {
        ConfigurationEngine engine = new ConfigurationEngine();
        engine.setConfigurationStorage(storage);
        ConfigConverter converter = page -> {
            try {
                return new VersionedJsonConfig(page.getVersion(), ConfigType.PAGE.name(), "" + page.getId(), mapper.valueToTree(page), null);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        };
        engine.setConverter(converter);
        return engine;
    }

    @Bean
    public ConfigListener configListener() {
        return new ConfigListener();
    }

    @Bean
    public GlobalInited globalInited(@Value(value="${xplat.oqsengine.sdk.init-size:5}") Integer size, @Value(value="${xplat.oqsengine.sdk.init-timeout:10}") Integer timeout) {
        return new GlobalInited(size, timeout);
    }

    @Bean
    public Object configurationRebuild(final ConfigurationStorage configurationStorage, final ConfigurationEngine<DictUpResult, JsonConfigNode> dictConfigEngine, final ConfigurationEngine<UltPage, JsonConfigNode> pageConfigEngine, final ConfigurationEngine<UltForm, JsonConfigNode> formConfigEngine, final ConfigurationEngine<ModuleUpResult, JsonConfigNode> moduleConfigEngine, final ApplicationEventPublisher publisher, final GlobalInited inited) {
        return new SmartInitializingSingleton(){

            public void afterSingletonsInstantiated() {
                List changeList = configurationStorage.rebuild();
                RuntimeConfigAutoConfiguration.this.logger.info("Rebuilding-------------------");
                changeList.stream().forEach(x -> publisher.publishEvent((Object)new ConfigChangeEvent(x.getType(), (ChangeList)x)));
                Optional.ofNullable(dictConfigEngine.getObservable()).ifPresent(ob -> ob.subscribe(x -> {
                    RuntimeConfigAutoConfiguration.this.logger.info("Get New Dict-------------------");
                    publisher.publishEvent((Object)new ConfigChangeEvent(x.getType(), (ChangeList)x));
                }));
                Optional.ofNullable(moduleConfigEngine.getObservable()).ifPresent(ob -> ob.subscribe(x -> {
                    RuntimeConfigAutoConfiguration.this.logger.info("Get New Module List-------------------");
                    publisher.publishEvent((Object)new ConfigChangeEvent(x.getType(), (ChangeList)x));
                    RuntimeConfigAutoConfiguration.this.logger.info("Should inserted");
                }));
                Optional.ofNullable(pageConfigEngine.getObservable()).ifPresent(ob -> ob.subscribe(x -> {
                    RuntimeConfigAutoConfiguration.this.logger.info("Get New Page-------------------");
                    publisher.publishEvent((Object)new ConfigChangeEvent(x.getType(), (ChangeList)x));
                }));
                Optional.ofNullable(formConfigEngine.getObservable()).ifPresent(ob -> ob.subscribe(x -> {
                    RuntimeConfigAutoConfiguration.this.logger.info("Get New Form-------------------");
                    publisher.publishEvent((Object)new ConfigChangeEvent(x.getType(), (ChangeList)x));
                }));
                RuntimeConfigAutoConfiguration.this.logger.info("Waiting for init");
                inited.waiting();
            }
        };
    }
}

