/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.config.perm.page;

import com.alibaba.fastjson.JSON;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.permission.RuleResult;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class PagePermissionClient {
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${xplat.oqsengine.sdk.permission.gateway}")
    private String permissionGateway;

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String getPermissionGateway() {
        return this.permissionGateway;
    }

    public void setPermissionGateway(String permissionGateway) {
        this.permissionGateway = permissionGateway;
    }

    public List<RuleResult> getRules(List<Long> codes, String pageCode, String appId, String tenantCode, String pageTenant) {
        Response result = new Response();
        HttpHeaders headers = new HttpHeaders();
        MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
        headers.setContentType(type);
        headers.add("Accept", MediaType.APPLICATION_JSON.toString());
        HttpEntity authorizeEntity = new HttpEntity(codes, (MultiValueMap)headers);
        UriComponentsBuilder host = UriComponentsBuilder.fromHttpUrl((String)this.permissionGateway).path("/appId/{appId}/tenants/{tenantCode}/pages/{pageCode}/rules");
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{pageTenant})) {
            host = host.queryParam("pageTenant", new Object[]{pageTenant});
        }
        URI build = host.build(new Object[]{appId, tenantCode, pageCode});
        result = (Response)this.restTemplate.postForObject(build, (Object)authorizeEntity, Response.class);
        return ((List)result.getResult()).stream().map(x -> (RuleResult)JSON.parseObject((String)JSON.toJSONString((Object)x), RuleResult.class)).collect(Collectors.toList());
    }
}

