/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.controller;

import com.xforceplus.ultraman.oqsengine.sdk.command.ConditionExportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.ConditionSearchCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.GetImportTemplateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.ImportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleCreateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleDeleteCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleQueryCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleUpdateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.ui.DefaultUiService;
import com.xforceplus.ultraman.oqsengine.sdk.vo.context.SDKContextKey;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.RowItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.SummaryItem;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import com.xforceplus.xplat.galaxy.framework.dispatcher.ServiceDispatcher;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@RequestMapping
public class EntityController {
    @Autowired
    private ServiceDispatcher dispatcher;
    private static String FAILED = "\u64cd\u4f5c\u5931\u8d25:";
    @Value(value="${xplat.oqsengine.sdk.export.maxsize:50000}")
    private int exportMaxSize;
    @Autowired
    private ContextService contextService;

    @GetMapping(value={"/bos/{boId}/entities/{id}"})
    @ResponseBody
    public ResponseEntity<Response<Map<String, Object>>> singleQuery(@PathVariable String boId, @PathVariable String id, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="pageCode") String pageCode) {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set((ContextService.ContextKey)SDKContextKey.PAGE, (Object)page);
        Either result = (Either)this.dispatcher.querySync((Object)new SingleQueryCmd(boId, id, version), DefaultUiService.class, "singleQuery");
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response<Map> rep = new Response<Map>();
            rep.setCode("1");
            rep.setMessage("\u83b7\u53d6\u6210\u529f");
            rep.setResult((Map)x);
            return ResponseEntity.ok(rep);
        }).getOrElseGet(str -> {
            Response rep = new Response();
            rep.setCode("-1");
            rep.setMessage(FAILED.concat((String)str));
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        });
    }

    @DeleteMapping(value={"/bos/{boId}/entities/{id}"})
    @ResponseBody
    public ResponseEntity<Response<String>> singleDelete(@PathVariable String boId, @PathVariable String id, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="pageCode") String pageCode) {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set((ContextService.ContextKey)SDKContextKey.PAGE, (Object)page);
        Either result = (Either)this.dispatcher.querySync((Object)new SingleDeleteCmd(boId, id, version), ResolvableType.forClassWithGenerics(Either.class, (Class[])new Class[]{String.class, Integer.class}));
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response<String> rep = new Response<String>();
            rep.setCode("1");
            rep.setResult(String.valueOf(x));
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok(rep);
        }).getOrElseGet(str -> {
            Response<String> rep = new Response<String>();
            rep.setCode("-1");
            rep.setMessage(FAILED.concat((String)str));
            rep.setResult((String)str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        });
    }

    @PostMapping(value={"/bos/{boId}/entities"})
    @ResponseBody
    public ResponseEntity<Response<String>> singleCreate(@PathVariable String boId, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="pageCode") String pageCode, @RequestBody Map<String, Object> body) {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set((ContextService.ContextKey)SDKContextKey.PAGE, (Object)page);
        Either result = (Either)this.dispatcher.querySync((Object)new SingleCreateCmd(boId, body, version), DefaultUiService.class, "singleCreate");
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response<String> rep = new Response<String>();
            rep.setCode("1");
            rep.setResult(String.valueOf(x));
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok(rep);
        }).getOrElseGet(str -> {
            Response<String> rep = new Response<String>();
            rep.setCode("-1");
            rep.setMessage(FAILED.concat((String)str));
            rep.setResult((String)str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        });
    }

    @PutMapping(value={"/bos/{boId}/entities/{id}"})
    @ResponseBody
    public ResponseEntity<Response<String>> singleModify(@PathVariable String boId, @PathVariable Long id, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="pageCode") String pageCode, @RequestBody Map<String, Object> body) {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set((ContextService.ContextKey)SDKContextKey.PAGE, (Object)page);
        Either result = (Either)this.dispatcher.querySync((Object)new SingleUpdateCmd(boId, id, body, version), ResolvableType.forClassWithGenerics(Either.class, (Class[])new Class[]{String.class, Integer.class}));
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response<String> rep = new Response<String>();
            rep.setCode("1");
            rep.setResult(String.valueOf(x));
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok(rep);
        }).getOrElseGet(str -> {
            Response<String> rep = new Response<String>();
            rep.setCode("-1");
            rep.setMessage(FAILED.concat((String)str));
            rep.setResult((String)str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        });
    }

    @PostMapping(value={"/bos/{boId}/entities/query"})
    @ResponseBody
    public ResponseEntity<Response<RowItem<Map<String, Object>>>> conditionQuery(@PathVariable String boId, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="pageCode") String page, @RequestBody ConditionQueryRequest condition) {
        String pageCode = Optional.ofNullable(page).orElse("PAGE");
        this.contextService.set((ContextService.ContextKey)SDKContextKey.PAGE, (Object)pageCode);
        if (condition != null) {
            if (condition.getPageNo() == null) {
                condition.setPageNo(1);
            }
            if (condition.getPageSize() == null) {
                condition.setPageSize(10);
            }
        }
        Either result = (Either)this.dispatcher.querySync((Object)new ConditionSearchCmd(boId, condition, version, page), DefaultUiService.class, "conditionSearch");
        return this.extractRepList(Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")));
    }

    private <T> ResponseEntity<Response<RowItem<T>>> extractRepList(Either<String, Tuple2<Integer, List<T>>> result) {
        Response rep = new Response();
        if (result.isRight()) {
            rep.setCode("1");
            Tuple2 tuple = (Tuple2)result.get();
            RowItem rowItem = new RowItem();
            rowItem.setSummary(new SummaryItem((Integer)tuple._1()));
            rowItem.setRows((List)tuple._2());
            rep.setResult(rowItem);
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok(rep);
        }
        rep.setCode("-1");
        rep.setMessage(FAILED.concat((String)result.getLeft()));
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
    }

    @PostMapping(value={"/bos/{boId}/entities/export"})
    @ResponseBody
    public CompletableFuture<Response<String>> conditionExport(@PathVariable String boId, @RequestParam(required=true, defaultValue="sync", value="exportType") String exportType, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="appId") String appId, @RequestParam(required=false, value="pageCode") String pageCode, @RequestBody ConditionQueryRequest condition) {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set((ContextService.ContextKey)SDKContextKey.PAGE, (Object)page);
        if (condition != null) {
            if (condition.getPageNo() == null) {
                condition.setPageNo(1);
            }
            if (condition.getPageSize() == null || condition.getPageSize() > this.exportMaxSize) {
                condition.setPageSize(this.exportMaxSize);
            }
        }
        CompletableFuture exportResult = (CompletableFuture)this.dispatcher.querySync((Object)new ConditionExportCmd(boId, condition, version, exportType, appId), DefaultUiService.class, "conditionExport");
        return exportResult.thenApply(x -> {
            if (x.isRight()) {
                Response<Object> response = new Response<Object>();
                response.setResult(x.get());
                response.setMessage("OK");
                response.setCode("1");
                return response;
            }
            return Response.Error((String)x.getLeft());
        });
    }

    @GetMapping(value={"/bos/{boId}/entities/import/template"})
    @ResponseBody
    public ResponseEntity<StreamingResponseBody> importTemplate(@PathVariable String boId, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="pageCode") String pageCode) {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set((ContextService.ContextKey)SDKContextKey.PAGE, (Object)page);
        Either importTemplate = (Either)this.dispatcher.querySync((Object)new GetImportTemplateCmd(boId, version), DefaultUiService.class, "importTemplate");
        if (importTemplate.isRight()) {
            InputStream finalInput = (InputStream)importTemplate.get();
            StreamingResponseBody responseBody = outputStream -> {
                StreamUtils.copy((InputStream)finalInput, (OutputStream)outputStream);
                outputStream.close();
            };
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=" + boId + "-template.csv"})).contentType(MediaType.APPLICATION_OCTET_STREAM).body((Object)responseBody);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
    }

    @PostMapping(value={"/bos/{boId}/entities/import"})
    @ResponseBody
    public ResponseEntity<Response<String>> importEntities(@PathVariable String boId, @RequestParam(required=false, value="v") String version, @RequestParam(required=false, value="pageCode") String pageCode, MultipartFile file) {
        String page = Optional.ofNullable(pageCode).orElse("PAGE");
        this.contextService.set((ContextService.ContextKey)SDKContextKey.PAGE, (Object)page);
        Either result = (Either)this.dispatcher.querySync((Object)new ImportCmd(boId, version, file), DefaultUiService.class, "batchImport");
        return (ResponseEntity)Optional.ofNullable(result).orElseGet(() -> Either.left((Object)"\u6ca1\u6709\u8fd4\u56de\u503c")).map(x -> {
            Response<String> rep = new Response<String>();
            rep.setCode("1");
            rep.setResult(String.valueOf(x));
            rep.setMessage("\u64cd\u4f5c\u6210\u529f");
            return ResponseEntity.ok(rep);
        }).getOrElseGet(str -> {
            Response<String> rep = new Response<String>();
            rep.setCode("-1");
            rep.setMessage(FAILED.concat((String)str));
            rep.setResult((String)str);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(rep);
        });
    }
}

