/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.controller;

import akka.NotUsed;
import akka.stream.javadsl.Source;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.EntityRebuildService;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.QueryPage;
import com.xforceplus.ultraman.oqsengine.sdk.RebuildRequest;
import com.xforceplus.ultraman.oqsengine.sdk.RebuildTaskInfo;
import com.xforceplus.ultraman.oqsengine.sdk.ShowTask;
import com.xforceplus.ultraman.oqsengine.sdk.service.EntityService;
import com.xforceplus.ultraman.oqsengine.sdk.util.EntityClassToGrpcConverter;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.RebuildRequestDTO;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.TaskInfoDTO;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping
public class EntityRebuildController {
    @Autowired
    private EntityRebuildService rebuildService;
    @Autowired
    private EntityService entityService;
    private static TaskInfoDTO MISSING = new TaskInfoDTO("-1", "\u5bf9\u8c61\u4e0d\u5b58\u5728");

    @GetMapping(value={"/rebuild/{taskId}/taskinfo"}, produces={"application/stream+json"})
    public Source<TaskInfoDTO, NotUsed> getTaskStream(@PathVariable Long taskId) {
        return this.rebuildService.showProgress(ShowTask.newBuilder().setId(taskId.longValue()).build()).map(this::toTaskInfoDTO);
    }

    @GetMapping(value={"/rebuild/list/active"}, produces={"application/stream+json"})
    public Source<TaskInfoDTO, NotUsed> listActiveTask(ConditionQueryRequest queryRequest) {
        return this.rebuildService.listActiveTasks(QueryPage.newBuilder().setNumber(queryRequest.getPageNo().intValue()).setSize(queryRequest.getPageSize().intValue()).build()).map(this::toTaskInfoDTO);
    }

    @GetMapping(value={"/rebuild/entity/id/{id}/active"})
    public CompletionStage<TaskInfoDTO> showCurrentTaskbyId(@PathVariable String id) {
        return this.entityService.load(id).map(this::getActiveTask).orElse(CompletableFuture.completedFuture(MISSING));
    }

    @GetMapping(value={"/rebuild/entity/code/{code}/active"})
    public CompletionStage<TaskInfoDTO> showCurrentTaskByCode(@PathVariable String code) {
        return this.entityService.loadByCode(code).map(this::getActiveTask).orElse(CompletableFuture.completedFuture(MISSING));
    }

    private CompletionStage<TaskInfoDTO> getActiveTask(IEntityClass entityClass) {
        return this.rebuildService.getActiveTask(EntityClassToGrpcConverter.toEntityUp(entityClass)).thenApply(this::toTaskInfoDTO);
    }

    @GetMapping(value={"/rebuild/list/all"}, produces={"application/stream+json"})
    public Source<TaskInfoDTO, NotUsed> listAllTask(ConditionQueryRequest queryRequest) {
        return this.rebuildService.listAllTasks(QueryPage.newBuilder().setNumber(queryRequest.getPageNo().intValue()).setSize(queryRequest.getPageSize().intValue()).build()).map(this::toTaskInfoDTO);
    }

    @PostMapping(value={"/rebuild/{taskId}/cancel"})
    public CompletionStage<TaskInfoDTO> cancel(@PathVariable String taskId) {
        return this.rebuildService.cancelTask(ShowTask.newBuilder().setId(Long.parseLong(taskId)).build()).thenApply(this::toTaskInfoDTO);
    }

    @PostMapping(value={"/rebuild/"})
    public CompletionStage<TaskInfoDTO> requestTask(@RequestBody RebuildRequestDTO rebuildRequest) {
        String code = rebuildRequest.getCode();
        String id = rebuildRequest.getId();
        String startDate = rebuildRequest.getStartDate();
        String endDate = rebuildRequest.getEndDate();
        Optional<Object> entityClass = Optional.empty();
        if (StringUtils.isEmpty((CharSequence)id)) {
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{code})) {
                entityClass = this.entityService.loadByCode(code);
            }
        } else {
            entityClass = this.entityService.load(id);
        }
        return entityClass.map(x -> {
            EntityUp entityUp = EntityClassToGrpcConverter.toEntityUp(x);
            return this.rebuildService.rebuildIndex(RebuildRequest.newBuilder().setEntity(entityUp).setStart(startDate).setEnd(endDate).build()).thenApply(this::toTaskInfoDTO);
        }).orElse(CompletableFuture.completedFuture(MISSING));
    }

    private TaskInfoDTO toTaskInfoDTO(RebuildTaskInfo rebuildTaskInfo) {
        TaskInfoDTO dto = new TaskInfoDTO();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{rebuildTaskInfo.getErrCode()}) && Integer.parseInt(rebuildTaskInfo.getErrCode()) < 0) {
            dto.setErrCode(rebuildTaskInfo.getErrCode());
            dto.setMessage(rebuildTaskInfo.getMessage());
            return dto;
        }
        dto.setBatchSize(rebuildTaskInfo.getBatchSize());
        dto.setCancel(rebuildTaskInfo.getIsCancel());
        dto.setDone(rebuildTaskInfo.getIsDone());
        dto.setEnds(Long.toString(rebuildTaskInfo.getEnds()));
        dto.setStarts(Long.toString(rebuildTaskInfo.getStarts()));
        dto.setTid(Long.toString(rebuildTaskInfo.getTid()));
        dto.setPercentage(rebuildTaskInfo.getPercentage());
        dto.setFinishSize(rebuildTaskInfo.getFinishSize());
        dto.setEntityId(Long.toString(rebuildTaskInfo.getEntityId()));
        dto.setStatus(rebuildTaskInfo.getStatus());
        return dto;
    }
}

