/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.controller;

import com.alibaba.fastjson.JSON;
import com.xforceplus.ultraman.oqsengine.pojo.auth.Authorization;
import com.xforceplus.ultraman.oqsengine.pojo.dto.UltForm;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.config.ExternalServiceConfig;
import com.xforceplus.ultraman.oqsengine.sdk.store.RowUtils;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.FormBoMapLocalStore;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ResponseList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.naming.directory.NoSuchAttributeException;
import javax.servlet.http.HttpServletRequest;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.builder.SatisfiedWhereBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

@RequestMapping
public class UltFormSettingController {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private FormBoMapLocalStore formBoMapLocalStore;
    @Autowired
    private AuthSearcherConfig config;

    @PostMapping(value={"/form-settings/{id}/deployments"})
    @ResponseBody
    public Response deploymentsForm(@PathVariable String id) throws NoSuchAttributeException {
        Response result = this.initSeetings(id);
        return result;
    }

    @GetMapping(value={"/form-settings/{id}"})
    @ResponseBody
    public Response pageBoSeetings(HttpServletRequest request, @PathVariable String id) throws NoSuchAttributeException {
        Object ds = null;
        String tenantCode = request.getParameter("tenantCode");
        Response response = new Response();
        if (!StringUtils.isEmpty((Object)id)) {
            ResponseList items = this.getSettings(id, tenantCode);
            if (items.size() == 1) {
                response.setMessage("\u67e5\u8be2\u6210\u529f");
                response.setCode("200");
                response.setResult(items.get(0));
                return response;
            }
            Response result = this.initSeetings(id);
            if (((List)result.getResult()).size() > 0) {
                items = this.getSettings(id, tenantCode);
            }
            if (items.size() == 1) {
                response.setMessage("\u67e5\u8be2\u6210\u529f");
                response.setCode("200");
                response.setResult(items.get(0));
                return response;
            }
            response.setMessage("\u83dc\u5355\u672a\u90e8\u7f72");
            response.setCode("500");
            return response;
        }
        response.setMessage("\u672a\u4f20id");
        response.setCode("1");
        return response;
    }

    private Response initSeetings(String id) throws NoSuchAttributeException {
        String accessUri = ExternalServiceConfig.PfcpAccessUri();
        String url = String.format("%s/forms/%s/deployments", accessUri, id);
        Authorization auth = new Authorization();
        auth.setAppId(Long.valueOf(Long.parseLong(this.config.getAppId())));
        auth.setEnv(this.config.getEnv());
        Response result = new Response();
        try {
            result = (Response)this.restTemplate.postForObject(url, (Object)auth, Response.class, new Object[0]);
            if (result.getResult() != null) {
                List ultForms = (List)result.getResult();
                for (int i = 0; i < ultForms.size(); ++i) {
                    UltForm saveUltForm = (UltForm)JSON.parseObject((String)JSON.toJSONString(ultForms.get(i)), UltForm.class);
                    this.formBoMapLocalStore.save(saveUltForm);
                }
            }
            return result;
        }
        catch (Exception e) {
            result.setCode("500");
            result.setMessage("\u83b7\u53d6\u5931\u8d25");
            return result;
        }
    }

    private ResponseList getSettings(String id, String tenantCode) {
        DataSet ds = null;
        if (!StringUtils.isEmpty((Object)id)) {
            List trows = new ArrayList();
            if (!StringUtils.isEmpty((Object)tenantCode)) {
                ds = ((SatisfiedWhereBuilder)((SatisfiedWhereBuilder)this.formBoMapLocalStore.query().selectAll().where("refFormId").eq(id)).and("tenantCode").eq(tenantCode)).execute();
                trows = ds.toRows();
            }
            if (ds != null && trows != null && trows.size() > 0) {
                ResponseList items = trows.stream().map(this::toUltForm).collect(Collectors.toCollection(ResponseList::new));
                return items;
            }
            ds = ((SatisfiedWhereBuilder)this.formBoMapLocalStore.query().selectAll().where("id").eq(id)).execute();
            List rows = ds.toRows();
            ResponseList items = rows.stream().map(this::toUltForm).collect(Collectors.toCollection(ResponseList::new));
            return items;
        }
        return null;
    }

    private UltForm toUltForm(Row row) {
        UltForm ultForm = new UltForm();
        ultForm.setId(Long.valueOf(Long.parseLong(RowUtils.getRowValue(row, "id").map(Object::toString).orElse(""))));
        ultForm.setName(RowUtils.getRowValue(row, "name").map(Object::toString).orElse(""));
        ultForm.setCode(RowUtils.getRowValue(row, "code").map(Object::toString).orElse(""));
        ultForm.setRefFormId(Long.valueOf(Long.parseLong(RowUtils.getRowValue(row, "refFormId").map(Object::toString).orElse(""))));
        if (!"".equals(RowUtils.getRowValue(row, "tenantId").map(Object::toString).orElse(""))) {
            ultForm.setTenantId(Long.valueOf(Long.parseLong(RowUtils.getRowValue(row, "tenantId").map(Object::toString).orElse(""))));
        }
        if (!"".equals(RowUtils.getRowValue(row, "tenantCode").map(Object::toString).orElse(""))) {
            ultForm.setTenantCode(RowUtils.getRowValue(row, "tenantCode").map(Object::toString).orElse(""));
        }
        ultForm.setTenantName(RowUtils.getRowValue(row, "tenantName").map(Object::toString).orElse(""));
        ultForm.setSetting(RowUtils.getRowValue(row, "setting").map(Object::toString).orElse(""));
        return ultForm;
    }
}

