/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.handler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.command.ConditionExportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.ConditionSearchCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.GetImportTemplateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.ImportCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.MetaDataLikeCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleCreateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleDeleteCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleQueryCmd;
import com.xforceplus.ultraman.oqsengine.sdk.command.SingleUpdateCmd;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpFactory;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.service.EntityService;
import com.xforceplus.ultraman.oqsengine.sdk.service.ExecutionService;
import com.xforceplus.ultraman.oqsengine.sdk.service.PagePermissionService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.EntityExportService;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.PageBoMapLocalStore;
import com.xforceplus.ultraman.oqsengine.sdk.ui.DefaultUiService;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.permission.ConditionExp;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.permission.RuleResult;
import com.xforceplus.xplat.galaxy.framework.context.ContextKeys;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import com.xforceplus.xplat.galaxy.framework.dispatcher.anno.QueryHandler;
import com.xforceplus.xplat.galaxy.framework.dispatcher.messaging.MetaData;
import com.xforceplus.xplat.galaxy.framework.dispatcher.messaging.QueryMessage;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class DefaultEntityServiceHandler
implements DefaultUiService {
    @Autowired
    private EntityService entityService;
    @Autowired
    private ExecutionService executionService;
    @Autowired
    private EntityExportService exportService;
    @Autowired
    private PagePermissionService pagePermissionService;
    @Autowired
    private PageBoMapLocalStore pageBoMapLocalStore;
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private ContextService contextService;
    @Autowired
    private AuthSearcherConfig auth;
    @Value(value="${xplat.oqsengine.sdk.permission.enabled:false}")
    private boolean enabled;
    private Logger logger = LoggerFactory.getLogger(DefaultUiService.class);
    private static final String MISSING_ENTITIES = "\u67e5\u8be2\u5bf9\u8c61\u4e0d\u5b58\u5728";
    private Logger log = LoggerFactory.getLogger(DefaultUiService.class);

    public Optional<IEntityClass> getEntityClass(MetaDataLikeCmd cmd) {
        return Optional.ofNullable(cmd.version()).map(x -> this.entityService.load(cmd.getBoId(), cmd.version())).orElseGet(() -> this.entityService.load(cmd.getBoId()));
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Map<String, Object>> singleQuery(SingleQueryCmd cmd) {
        Optional<IEntityClass> entityClassOp = this.getEntityClass(cmd);
        if (entityClassOp.isPresent()) {
            return this.entityService.findOne(entityClassOp.get(), Long.parseLong(cmd.getId()));
        }
        return Either.left((Object)MISSING_ENTITIES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Integer> singleDelete(SingleDeleteCmd cmd) {
        Optional<IEntityClass> entityClassOp = this.getEntityClass(cmd);
        if (entityClassOp.isPresent()) {
            return this.entityService.deleteOne(entityClassOp.get(), Long.valueOf(cmd.getId()));
        }
        return Either.left((Object)MISSING_ENTITIES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Long> singleCreate(SingleCreateCmd cmd) {
        Optional<IEntityClass> entityClassOp = this.getEntityClass(cmd);
        if (entityClassOp.isPresent()) {
            return this.entityService.create(entityClassOp.get(), cmd.getBody());
        }
        return Either.left((Object)MISSING_ENTITIES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Integer> singleUpdate(SingleUpdateCmd cmd) {
        Optional<IEntityClass> entityClassOp = this.getEntityClass(cmd);
        if (entityClassOp.isPresent()) {
            return this.entityService.updateById(entityClassOp.get(), cmd.getId(), cmd.getBody());
        }
        return Either.left((Object)MISSING_ENTITIES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, Tuple2<Integer, List<Map<String, Object>>>> conditionSearch(ConditionSearchCmd cmd) {
        Optional<IEntityClass> entityClassOp = this.getEntityClass(cmd);
        Optional<Object> queryFromPermission = Optional.empty();
        String pageCode = cmd.getPageCode();
        if (pageCode != null && !pageCode.isEmpty() && this.enabled) {
            Long tenantId = (Long)this.contextService.get((ContextService.ContextKey)ContextKeys.LongKeys.TENANT_ID);
            String tenantCode = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TENANTCODE_KEY);
            Collection roles = (Collection)this.contextService.get((ContextService.ContextKey)ContextKeys.CollectionKeys.ROLE_IDS);
            if (tenantId != null && roles != null && !StringUtils.isEmpty((Object)tenantCode)) {
                long start = System.currentTimeMillis();
                List<RuleResult> ruleResults = this.pagePermissionService.getRuleResults(tenantId, null, this.auth.getAppId(), pageCode, tenantCode, null, new ArrayList<Long>(roles));
                this.logger.debug("Get Permission using {}ms", (Object)(System.currentTimeMillis() - start));
                queryFromPermission = ruleResults.stream().filter(x -> x.getEntityId().equals(Long.parseLong(cmd.getBoId()))).flatMap(x -> {
                    try {
                        String rowRule = x.getRowRule();
                        String columnRule = x.getColumnRule();
                        List conditionExps = (List)this.mapper.readValue(rowRule, (TypeReference)new TypeReference<List<List<ConditionExp>>>(){});
                        List columns = (List)this.mapper.readValue(columnRule, (TypeReference)new TypeReference<List<String>>(){});
                        return conditionExps.stream().map(andList -> ExpFactory.createFrom(columns, andList));
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }).filter(Objects::nonNull).map(x -> x).reduce(ExpRel::mergeOr);
            }
        }
        ConditionQueryRequest conditionQueryRequest = cmd.getConditionQueryRequest();
        ExpRel condition = ExpFactory.createFrom(conditionQueryRequest);
        if (queryFromPermission.isPresent()) {
            condition = condition.mergeAnd((ExpRel)queryFromPermission.get());
        }
        if (entityClassOp.isPresent()) {
            ExpContext expContext = new ExpContext().withSchema(entityClassOp.get()).withContext(this.contextService.getAll());
            Long queryStart = System.currentTimeMillis();
            Either<String, DataCollection<Record>> query = this.executionService.query(expContext, condition);
            this.logger.info("Query using {}ms", (Object)(System.currentTimeMillis() - queryStart));
            ExpRel finalCondition = condition;
            return query.map(x -> Tuple.of((Object)x.getRowNum(), x.getRows().stream().map(y -> y.toMap(finalCondition.getProjects().stream().map(p -> ((ExpField)p).getName()).collect(Collectors.toSet()))).collect(Collectors.toList())));
        }
        return Either.left((Object)MISSING_ENTITIES);
    }

    @Override
    @QueryHandler(isDefault=true)
    public CompletableFuture<Either<String, String>> conditionExport(QueryMessage<ConditionExportCmd, ?> message) {
        ConditionExportCmd cmd = (ConditionExportCmd)message.getPayload();
        MetaData metaData = message.getMetaData();
        Long currentTime = System.nanoTime();
        String token = Optional.ofNullable(metaData.get((Object)"code")).map(Object::toString).orElse(cmd.getBoId()).trim() + "-" + currentTime;
        String fileName = Optional.ofNullable(metaData.get((Object)"name")).map(Object::toString).map(String::trim).orElse(Optional.ofNullable(metaData.get((Object)"code")).map(Object::toString).orElse(cmd.getBoId())).trim() + "-" + currentTime;
        Optional<IEntityClass> iEntityClassOp = cmd.getBoId() != null ? this.entityService.load(cmd.getBoId()) : this.entityService.load(cmd.getBoId(), cmd.version());
        if (!iEntityClassOp.isPresent()) {
            return CompletableFuture.completedFuture(Either.left((Object)MISSING_ENTITIES));
        }
        return this.exportService.export(iEntityClassOp.get(), cmd.getConditionQueryRequest(), token, fileName, new HashMap<String, Object>((Map<String, Object>)metaData), cmd.getExportType(), cmd.getAppId());
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, InputStream> importTemplate(GetImportTemplateCmd cmd) {
        String boId = cmd.getBoId();
        Optional<IEntityClass> entityClass = this.entityService.load(boId);
        if (entityClass.isPresent()) {
            IEntityClassReader reader = new IEntityClassReader(entityClass.get(), new IEntityClass[0]);
            List fields = reader.columns();
            byte[] bom = new byte[]{-17, -69, -65};
            String columns = fields.stream().map(x -> x.cnName() + "[" + x.name() + "]").map(StringEscapeUtils::escapeCsv).collect(Collectors.joining(","));
            byte[] bytes = columns.getBytes(StandardCharsets.UTF_8);
            byte[] allBytes = new byte[bom.length + bytes.length];
            for (int i = 0; i < allBytes.length; ++i) {
                allBytes[i] = i < bom.length ? bom[i] : bytes[i - bom.length];
            }
            return Either.right((Object)new ByteArrayInputStream(allBytes));
        }
        return Either.left((Object)MISSING_ENTITIES);
    }

    private String getKeyFromHeader(String headerPart) {
        int start = headerPart.indexOf("[");
        int end = headerPart.indexOf("]");
        if (start < 0 || end < 0) {
            return headerPart;
        }
        return headerPart.substring(start + 1, end);
    }

    @Override
    @QueryHandler(isDefault=true)
    public Either<String, String> batchImport(ImportCmd cmd) {
        String boId = cmd.getBoId();
        Optional<IEntityClass> entityClassOp = this.entityService.load(boId);
        if (entityClassOp.isPresent()) {
            Either<String, String> ret;
            MultipartFile file = cmd.getFile();
            try {
                CSVParser parser = CSVParser.parse((InputStream)file.getInputStream(), (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.EXCEL);
                List list = parser.getRecords();
                HashMap map = new HashMap();
                if (list.size() > 1) {
                    CSVRecord header = (CSVRecord)list.get(0);
                    ret = this.entityService.transactionalExecute(() -> {
                        for (int i = 1; i < list.size(); ++i) {
                            CSVRecord record = (CSVRecord)list.get(i);
                            for (int j = 0; j < header.size(); ++j) {
                                map.put(this.getKeyFromHeader(header.get(j)), StringUtils.isEmpty((Object)record.get(j)) ? null : record.get(j));
                            }
                            this.entityService.create((IEntityClass)entityClassOp.get(), map);
                        }
                        return "ok";
                    });
                } else {
                    ret = Either.right((Object)"ok");
                }
                parser.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                ret = Either.left((Object)e.getMessage());
            }
            return ret;
        }
        return Either.left((Object)MISSING_ENTITIES);
    }
}

