/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.listener;

import com.xforceplus.ultraman.metadata.grpc.Base;
import com.xforceplus.ultraman.metadata.grpc.CheckServiceClient;
import com.xforceplus.ultraman.metadata.grpc.ModuleUp;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.error.ERROR;
import com.xforceplus.ultraman.oqsengine.sdk.EntityService;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
import com.xforceplus.ultraman.oqsengine.sdk.autoconfigurer.GlobalInited;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModuleFatalErrorEvent;
import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModuleGotEvent;
import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModulePrepareResultEvent;
import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModulePreparedErrorEvent;
import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModulePreparedEvent;
import com.xforceplus.ultraman.oqsengine.sdk.event.MetadataModuleVersionMissingEvent;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.CurrentUpdateService;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl.MetadataRepositoryInMemoryImpl;
import com.xforceplus.ultraman.oqsengine.sdk.util.CompletableFutureUtils;
import com.xforceplus.ultraman.oqsengine.sdk.util.EntityClassToGrpcConverter;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.concurrent.CompletableToListenableFutureAdapter;
import org.springframework.util.concurrent.ListenableFuture;

public class ModuleEventListener {
    @Autowired
    private MetadataRepository store;
    @Autowired
    private CheckServiceClient checkServiceClient;
    @Autowired
    private EntityService entityService;
    @Autowired
    private AuthSearcherConfig config;
    Logger logger = LoggerFactory.getLogger(ModuleEventListener.class);
    @Autowired
    public ApplicationEventPublisher publisher;
    @Autowired
    public CurrentUpdateService currentUpdateService;
    @Autowired
    public GlobalInited globalInited;
    @Value(value="${xplat.meta.oqsengine.sdk.preparation:10}")
    public int prepareTimeInSec;

    @EventListener(value={MetadataModuleGotEvent.class})
    public ListenableFuture<List<MetadataModulePrepareResultEvent>> saveMetadata(MetadataModuleGotEvent event) {
        List moduleUpResults = Optional.ofNullable(event.getResponse()).orElseGet(Collections::emptyList);
        MetadataRepositoryInMemoryImpl metadataRepository = new MetadataRepositoryInMemoryImpl(1, null);
        List retFutures = moduleUpResults.stream().map(module -> {
            this.logger.debug("Got New Module {}", (Object)event);
            metadataRepository.save((ModuleUpResult)module, "1", "1");
            List<IEntityClass> allEntities = metadataRepository.findAllEntities();
            LinkedList results = new LinkedList();
            allEntities.forEach(x -> {
                EntityUp entityUp = EntityClassToGrpcConverter.toEntityUp(x);
                CompletableFuture<Tuple2> prepare = this.entityService.prepare(entityUp).thenApply(rep -> Tuple.of((Object)entityUp, (Object)rep)).toCompletableFuture();
                CompletionStage withinTimeout = CompletableFutureUtils.within(prepare, Duration.ofSeconds(this.prepareTimeInSec)).exceptionally(throwable -> {
                    this.logger.error("prepare {} timeout, throwable {}", (Object)x.code(), throwable);
                    return Tuple.of((Object)entityUp, (Object)OperationResult.newBuilder().setCode(OperationResult.Code.NETWORK_ERR).build());
                });
                results.add(withinTimeout);
            });
            return CompletableFutureUtils.sequence(results).thenApply(x -> {
                if (x.stream().allMatch(r -> ((OperationResult)r._2()).getCode() == OperationResult.Code.OK)) {
                    this.logger.info("Module {}:{} saved ", (Object)module.getId(), (Object)module.getCode());
                    return new MetadataModulePreparedEvent((ModuleUpResult)module, event.getRequest().getTenantId(), event.getRequest().getAppId());
                }
                this.logger.error("Module {} version {} is invalid retry later", (Object)module.getCode(), (Object)module.getVersion());
                boolean isFatal = x.stream().filter(r -> ((OperationResult)r._2()).getCode() != OperationResult.Code.OK).anyMatch(r -> ((OperationResult)r._2()).getAffectedRow() == ERROR.VALIDATION_ERROR.ordinal() || ((OperationResult)r._2()).getAffectedRow() == ERROR.REACH_MAX_SLOT.ordinal());
                if (isFatal) {
                    this.logger.error("Fatal {}", module);
                    return new MetadataModuleFatalErrorEvent((ModuleUpResult)module, event.getRequest().getTenantId(), event.getRequest().getAppId(), x.stream().filter(r -> ((OperationResult)r._2()).getCode() != OperationResult.Code.OK).collect(Collectors.toList()));
                }
                return new MetadataModulePreparedErrorEvent((ModuleUpResult)module, event.getRequest().getTenantId(), event.getRequest().getAppId(), x.stream().filter(r -> ((OperationResult)r._2()).getCode() != OperationResult.Code.OK).collect(Collectors.toList()));
            });
        }).collect(Collectors.toList());
        return new CompletableToListenableFutureAdapter(CompletableFutureUtils.sequence(retFutures));
    }

    @EventListener(value={MetadataModulePreparedEvent.class})
    public void cleanUpdateAndSave(MetadataModulePreparedEvent preparedEvent) {
        MetadataModulePreparedEvent preparedEventType = preparedEvent;
        ModuleUpResult module = preparedEventType.getModuleUpResult();
        this.store.save(module, preparedEventType.getTenantId(), preparedEventType.getAppId());
        this.globalInited.moduleSaved();
    }

    @Async
    @EventListener(value={MetadataModulePreparedErrorEvent.class})
    public void recordFailed(MetadataModulePreparedErrorEvent errorEvent) {
        MetadataModulePreparedErrorEvent errorEventType = errorEvent;
        this.currentUpdateService.recordResults(errorEventType.getModuleUpResult(), errorEventType.getErrorResult());
    }

    @Async
    @EventListener(value={MetadataModuleVersionMissingEvent.class})
    public void requestMetadata(MetadataModuleVersionMissingEvent event) {
        this.logger.debug("Got Module Missing {}", (Object)event);
        Base.Authorization request = Base.Authorization.newBuilder().setAppId(this.config.getAppId()).setEnv(this.config.getEnv()).setTenantId(this.config.getTenant()).build();
        Long module = event.getModuleId();
        String version = event.getVersion();
        ModuleUpResult result = (ModuleUpResult)this.checkServiceClient.check(ModuleUp.newBuilder().setModuleId(module.toString()).setModuleVersion(version).addAuthorization(request).build()).toCompletableFuture().join();
        this.logger.debug("Got Versioned Module {}", (Object)result);
        this.store.save(result, this.config.getTenant(), this.config.getAppId());
        this.logger.debug("Versioned Module saved {}", (Object)Optional.ofNullable(result).map(x -> x.getVersion()).orElseGet(() -> "none"));
    }
}

