/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.query.dsl;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpContext {
    private IEntityClassReader schema = null;
    private Map<String, Object> context = null;
    private Logger logger = LoggerFactory.getLogger(ExpContext.class);

    public ExpContext withContext(Map<String, Object> context) {
        this.context = new HashMap<String, Object>(context);
        return this;
    }

    public ExpContext withSchema(IEntityClass entityClass) {
        if (this.schema != null) {
            this.logger.warn("Changing Schema when has set, it maybe not properly");
        }
        if (entityClass == null) {
            this.logger.warn("Schema is empty");
            return this;
        }
        this.schema = new IEntityClassReader(entityClass, new IEntityClass[0]);
        return this;
    }

    public IEntityClassReader getSchema() {
        return this.schema;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }
}

