/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.query.dsl;

import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpSort;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpValue;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionOp;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Conditions;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.EntityItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldCondition;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.NameMapping;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.SubFieldCondition;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.permission.ConditionExp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExpFactory {
    private static ExpCondition toCondition(ConditionExp exp) {
        LinkedList<ExpNode> expNodes = new LinkedList<ExpNode>();
        expNodes.add(ExpField.field(exp.getField()));
        if (exp.getValue() != null) {
            List values = exp.getValue().stream().filter(Objects::nonNull).map(ExpValue::literal).collect(Collectors.toList());
            expNodes.addAll(values);
        } else {
            if (exp.getFrom() != null) {
                expNodes.add(ExpValue.literal(exp.getFrom()));
            }
            if (exp.getTo() != null) {
                expNodes.add(ExpValue.literal(exp.getTo()));
            }
        }
        return ExpCondition.call(ExpOperator.from(ConditionOp.valueOf(exp.getOperator())), expNodes);
    }

    public static ExpQuery createFrom(List<String> columns, List<ConditionExp> exps) {
        Objects.requireNonNull(exps, "Condition expression cannot be null");
        return new ExpQuery().project(columns.stream().map(ExpField::field).collect(Collectors.toList())).filters(exps.stream().map(ExpFactory::toCondition).collect(Collectors.toList()));
    }

    public static ExpQuery createFrom(ConditionQueryRequest request) {
        Objects.requireNonNull(request, "ConditionQueryRequest cannot be null");
        Conditions conditions = request.getConditions();
        ExpCondition expCondition = ExpCondition.alwaysTrue();
        if (conditions != null) {
            Stream expRelSubStream;
            List<SubFieldCondition> entities = conditions.getEntities();
            List<FieldCondition> fields = conditions.getFields();
            Stream<ExpCondition> expRelStream = Optional.ofNullable(fields).orElseGet(Collections::emptyList).stream().map(condition -> {
                List nodes = condition.getValue().stream().map(ExpValue::literal).collect(Collectors.toList());
                ExpField fieldExp = ExpField.field(condition.getCode());
                LinkedList<ExpNode> expNodes = new LinkedList<ExpNode>();
                expNodes.add(fieldExp);
                expNodes.addAll(nodes);
                return ExpCondition.call(ExpOperator.from(condition.getOperation()), expNodes);
            });
            List<ExpNode> expRelList = Stream.concat(expRelStream, expRelSubStream = Optional.ofNullable(entities).orElseGet(Collections::emptyList).stream().flatMap(sub -> sub.getFields().stream().map(subCondition -> {
                List nodes = subCondition.getValue().stream().map(ExpValue::literal).collect(Collectors.toList());
                ExpField fieldExp = ExpField.field(sub.getCode() + "." + subCondition.getCode());
                LinkedList<ExpNode> expNodes = new LinkedList<ExpNode>();
                expNodes.add(fieldExp);
                expNodes.addAll(nodes);
                return ExpCondition.call(ExpOperator.from(subCondition.getOperation()), expNodes);
            }))).collect(Collectors.toList());
            expCondition = expRelList.isEmpty() ? ExpCondition.alwaysTrue() : ExpCondition.AND(expRelList);
        }
        List fieldProject = null;
        EntityItem entityItem = request.getEntity();
        ArrayList<String> fields = new ArrayList<String>();
        if (entityItem != null) {
            List<String> projects = entityItem.getFields();
            fields.addAll(projects);
            if (entityItem.getEntities() != null) {
                List subProjects = entityItem.getEntities().stream().flatMap(x -> x.getFields().stream().map(y -> "_" + x.getCode() + "." + y)).collect(Collectors.toList());
                fields.addAll(subProjects);
            }
            List<NameMapping> mapping = request.getMapping();
            Map<String, String> nameMapping = Optional.ofNullable(mapping).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(NameMapping::getCode, NameMapping::getText));
            fieldProject = fields.stream().map(x -> {
                ExpField field = ExpField.field(x);
                nameMapping.computeIfPresent((String)x, (k, v) -> {
                    field.as((String)v);
                    return v;
                });
                return field;
            }).collect(Collectors.toList());
        }
        ExpSort sort = ExpSort.init();
        Optional.ofNullable(request.getSort()).orElseGet(Collections::emptyList).forEach(x -> sort.withSort(x.getField(), x.getOrder()));
        ExpQuery expQuery = new ExpQuery();
        expQuery.project(Optional.ofNullable(fieldProject).orElseGet(Collections::emptyList));
        expQuery.filters(expCondition);
        expQuery.sort(sort);
        expQuery.range(request.getPageNo(), request.getPageSize());
        return expQuery;
    }
}

