/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.query.dsl;

import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionOp;
import java.util.function.Predicate;
import java.util.stream.Stream;

public enum ExpOperator {
    OR(null, PreDef.atLeast1),
    AND(null, PreDef.atLeast1),
    EQUALS(ConditionOp.eq, PreDef.binary),
    LIKE(ConditionOp.like, PreDef.binary),
    IN(ConditionOp.in, PreDef.atLeast1),
    NOT_IN(ConditionOp.ni, PreDef.atLeast1),
    GREATER_EQ_AND_LESS_EQ(ConditionOp.ge_le, PreDef.ternary),
    GREATER_EQ_AND_LESS_THAN(ConditionOp.ge_lt, PreDef.ternary),
    GREATER_THAN_AND_LESS_EQ(ConditionOp.gt_le, PreDef.ternary),
    GREATER_THAN_AND_LESS_THAN(ConditionOp.gt_lt, PreDef.ternary),
    GREATER_THAN(ConditionOp.gt, PreDef.binary),
    GREATER_EQUALS(ConditionOp.ge, PreDef.binary),
    LESS_THAN(ConditionOp.lt, PreDef.binary),
    LESS_EQUALS(ConditionOp.le, PreDef.binary),
    NOT_EQUALS(ConditionOp.ne, PreDef.binary),
    DUMMY(null, PreDef.allowEmpty);

    ConditionOp op;
    Predicate<Integer> checkSize;

    private ExpOperator(ConditionOp op, Predicate<Integer> checkSize) {
        this.op = op;
        this.checkSize = checkSize;
    }

    public String getShortName() {
        if (this == OR) {
            return "or";
        }
        if (this == AND) {
            return "and";
        }
        return this.op.name();
    }

    public static ExpOperator from(ConditionOp op) {
        return Stream.of(ExpOperator.values()).filter(x -> x.op == op).findFirst().get();
    }

    public static class PreDef {
        public static final Predicate<Integer> binary = s -> s == 2;
        public static final Predicate<Integer> unary = s -> s == 1;
        public static final Predicate<Integer> ternary = s -> s == 3;
        public static final Predicate<Integer> atLeast1 = s -> s > 0;
        public static final Predicate<Integer> allowEmpty = s -> s >= 0;
    }
}

