/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.query.dsl;

import com.google.common.collect.Sets;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRange;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpSort;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ExpQuery
implements ExpRel {
    private List<ExpNode> projects = new LinkedList<ExpNode>();
    private List<ExpNode> filters = new LinkedList<ExpNode>();
    private ExpSort sorts;
    private ExpRange range;

    public ExpQuery project(List<ExpNode> nodes) {
        this.projects.addAll(nodes);
        return this;
    }

    public ExpQuery filters(List<ExpNode> nodes) {
        this.filters.addAll(nodes);
        return this;
    }

    public ExpQuery filters(ExpNode condition) {
        this.filters.add(condition);
        return this;
    }

    public ExpQuery sort(ExpSort sorts) {
        this.sorts = sorts;
        return this;
    }

    public ExpQuery range(Integer pageNo, Integer pageSize) {
        this.range = new ExpRange(pageNo, pageSize);
        return this;
    }

    @Override
    public List<ExpNode> getProjects() {
        return this.projects;
    }

    @Override
    public List<ExpNode> getFilters() {
        return this.filters;
    }

    @Override
    public ExpSort getSorts() {
        return this.sorts;
    }

    @Override
    public ExpRange getRange() {
        return this.range;
    }

    @Override
    public ExpRel mergeOr(ExpRel rel) {
        return this.mergeInternal(rel, 0);
    }

    @Override
    public ExpRel mergeAnd(ExpRel rel) {
        return this.mergeInternal(rel, 1);
    }

    private ExpRel mergeInternal(ExpRel rel, int type) {
        if (rel instanceof ExpQuery) {
            HashSet mergedProjects;
            ExpQuery merged = new ExpQuery();
            ExpQuery left = this;
            ExpQuery right = (ExpQuery)rel;
            HashSet<ExpNode> projectsLeft = new HashSet<ExpNode>(left.getProjects());
            HashSet<ExpNode> projectsRight = new HashSet<ExpNode>(right.getProjects());
            if (type == 0) {
                mergedProjects = Sets.newHashSet(projectsLeft);
                mergedProjects.addAll(projectsRight);
            } else {
                mergedProjects = Sets.intersection(projectsLeft, projectsRight);
            }
            ArrayList<ExpNode> newProjects = new ArrayList<ExpNode>(mergedProjects);
            List<ExpNode> filtersLeft = left.getFilters();
            List<ExpNode> filtersRight = right.getFilters();
            ExpCondition leftAnd = filtersLeft.isEmpty() ? ExpCondition.alwaysTrue() : ExpCondition.call(ExpOperator.AND, filtersLeft);
            ExpCondition rightAnd = filtersRight.isEmpty() ? ExpCondition.alwaysTrue() : ExpCondition.call(ExpOperator.AND, filtersRight);
            ExpCondition unionOr = ExpCondition.call(type == 0 ? ExpOperator.OR : ExpOperator.AND, Arrays.asList(leftAnd, rightAnd));
            LinkedList<ExpSort.FieldSort> newSorts = new LinkedList<ExpSort.FieldSort>(Optional.ofNullable(left.sorts).map(ExpSort::getSorts).orElseGet(Collections::emptyList));
            newSorts.addAll(Optional.ofNullable(right.sorts).map(ExpSort::getSorts).orElseGet(Collections::emptyList));
            merged.project(newProjects).filters(unionOr).sort(ExpSort.init().setSorts(newSorts));
            if (this.range != null) {
                merged.range(this.range.getIndex(), this.range.getSize());
            }
            return merged;
        }
        return this;
    }

    @Override
    public <T> T accept(ExpVisitor<T> visitor) {
        T t;
        List projectsT = this.projects.stream().map(visitor::visitGeneral).collect(Collectors.toList());
        List filtersT = this.filters.stream().map(visitor::visitGeneral).collect(Collectors.toList());
        if (this.sorts != null) {
            t = visitor.visit(this.sorts);
        }
        if (this.range != null) {
            t = visitor.visit(this.range);
        }
        return null;
    }
}

