/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.query.dsl;

import com.google.common.collect.Sets;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpVisitor;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class ExpSort
extends ExpNode {
    private List<FieldSort> sorts = new LinkedList<FieldSort>();

    @Override
    public <R> R accept(ExpVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public static ExpSort init() {
        return new ExpSort();
    }

    public ExpSort withSort(String fieldName, String sort) {
        this.sorts.add(new FieldSort(fieldName, Sort.from(sort)));
        return this;
    }

    public List<FieldSort> getSorts() {
        return this.sorts;
    }

    public ExpSort setSorts(List<FieldSort> sorts) {
        this.sorts.addAll(sorts);
        return this;
    }

    public ExpSort addSort(FieldSort fieldSort) {
        this.sorts.add(fieldSort);
        return this;
    }

    public static class FieldSort {
        private String code;
        private Sort sort;

        public FieldSort(String code, Sort sort) {
            this.code = code;
            this.sort = sort;
        }

        public String getCode() {
            return this.code;
        }

        public Sort getSort() {
            return this.sort;
        }
    }

    public static enum Sort {
        ASCEND("asc", "ascend"),
        DESCEND("desc", "descend");

        Set<String> aliase;

        private Sort(String ... aliase) {
            this.aliase = Sets.newHashSet((Object[])aliase);
        }

        public static Sort from(String value) {
            Objects.requireNonNull(value, "Sort value cannot be null");
            Optional<Sort> first = Stream.of(Sort.values()).filter(x -> x.aliase.contains(value.toLowerCase())).findFirst();
            return first.orElseThrow(() -> new RuntimeException("Error input " + value));
        }
    }
}

