/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.query.transformer;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpBi;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRange;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpSort;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpValue;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpVisitor;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.ExpTreeTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.service.OperationType;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.QuerySideFieldOperationHandler;
import com.xforceplus.ultraman.oqsengine.sdk.service.operation.TriFunction;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryValueHandlerTransformer
implements ExpTreeTransformer {
    private Logger logger = LoggerFactory.getLogger(QueryValueHandlerTransformer.class);
    final List<QuerySideFieldOperationHandler> querySideFieldOperationHandler;

    public QueryValueHandlerTransformer(List<QuerySideFieldOperationHandler> querySideFieldOperationHandler) {
        this.querySideFieldOperationHandler = querySideFieldOperationHandler;
    }

    @Override
    public ExpRel transform(ExpContext expContext, ExpRel expRel) {
        long transformStart = System.currentTimeMillis();
        expRel.getFilters().forEach(expNode -> expNode.accept(new ContextAwareVisitor(expContext)));
        this.logger.info("Query Transform consume {}ms", (Object)(System.currentTimeMillis() - transformStart));
        return expRel;
    }

    @Override
    public int getOrder() {
        return 2147473647;
    }

    private Object pipeline(Object value, IEntityField field, OperationType phase) {
        try {
            return this.querySideFieldOperationHandler.stream().sorted().map(x -> x).reduce(TriFunction::andThen).map(x -> x.apply(field, value, phase)).orElse(value);
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
            return null;
        }
    }

    class ContextAwareVisitor
    implements ExpVisitor<Void> {
        private ExpContext context;

        public ContextAwareVisitor(ExpContext context) {
            this.context = context;
        }

        @Override
        public Void visit(ExpField field) {
            return null;
        }

        @Override
        public Void visit(ExpCondition rel) {
            IEntityClassReader schema = this.context.getSchema();
            if (rel.getOperator() != ExpOperator.AND && rel.getOperator() != ExpOperator.OR) {
                ExpField field;
                Optional schemaField;
                Optional<ExpNode> firstField = rel.getExpNodes().stream().filter(x -> x instanceof ExpField).findFirst();
                if (firstField.isPresent() && (schemaField = schema.column((field = (ExpField)firstField.get()).getName())).isPresent()) {
                    rel.getExpNodes().stream().filter(x -> x instanceof ExpValue).forEach(x -> {
                        Object pipeline = QueryValueHandlerTransformer.this.pipeline(((ExpValue)x).getStrValue(), (IEntityField)schemaField.get(), OperationType.QUERY);
                        if (pipeline != null) {
                            ((ExpValue)x).changeStrValue(pipeline.toString());
                        }
                    });
                }
            } else {
                rel.getExpNodes().forEach(x -> x.accept(this));
            }
            return null;
        }

        @Override
        public Void visit(ExpValue value) {
            return null;
        }

        @Override
        public Void visit(ExpBi bi) {
            return null;
        }

        @Override
        public Void visit(ExpSort expSort) {
            return null;
        }

        @Override
        public Void visit(ExpRange range) {
            return null;
        }
    }
}

