/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer;

import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpBi;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRange;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpSort;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpValue;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpVisitor;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer.ExpConditionOptimizer;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer.utils.ExpTreeToRel;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rel2sql.RelToSqlConverter;
import org.apache.calcite.rel.rules.PruneEmptyRules;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CalciteConditionOptimizer
implements ExpConditionOptimizer {
    private Logger logger = LoggerFactory.getLogger(CalciteConditionOptimizer.class);
    @Autowired
    private List<RelOptRule> rules;
    @Autowired
    private FrameworkConfig config;

    @Override
    public ExpRel transform(ExpContext expContext, ExpRel expRel) {
        OrCheckVisitor orCheckVisitor = new OrCheckVisitor();
        expRel.accept(orCheckVisitor);
        if (orCheckVisitor.hasOr) {
            long optimizer = System.currentTimeMillis();
            RelNode opTree = ExpTreeToRel.toRelTree(expContext.getSchema().getEntityClass(), expRel, this.config);
            long transToTree = System.currentTimeMillis();
            this.logger.info("Trans consume {}ms", (Object)(transToTree - optimizer));
            HepProgramBuilder hepProgramBuilder = HepProgram.builder().addRuleInstance(PruneEmptyRules.FILTER_INSTANCE).addRuleInstance((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE);
            this.rules.forEach(arg_0 -> ((HepProgramBuilder)hepProgramBuilder).addRuleInstance(arg_0));
            HepProgram program = hepProgramBuilder.build();
            HepPlanner hepPlanner = new HepPlanner(program);
            hepPlanner.setRoot(opTree);
            RelNode optimized = hepPlanner.findBestExp();
            this.logger.info("Real Optimizer consume {}ms", (Object)(System.currentTimeMillis() - transToTree));
            SqlNode sqlNodeOrigin = new RelToSqlConverter(CalciteSqlDialect.DEFAULT).visitChild(0, opTree).asStatement();
            SqlNode sqlNode = new RelToSqlConverter(CalciteSqlDialect.DEFAULT).visitChild(0, optimized).asStatement();
            this.logger.debug("Origin is:" + Util.toLinux((String)sqlNodeOrigin.toSqlString(CalciteSqlDialect.DEFAULT).getSql()).replaceAll("\n", " "));
            this.logger.debug("Current is:" + Util.toLinux((String)sqlNode.toSqlString(CalciteSqlDialect.DEFAULT).getSql()).replaceAll("\n", " "));
            List fieldList = optimized.getRowType().getFieldList();
            ExpNode query = ExpTreeToRel.toExpTree(optimized, fieldList);
            ExpQuery newQuery = new ExpQuery();
            newQuery.project(expRel.getProjects()).filters(query).sort(expRel.getSorts());
            if (expRel.getRange() != null) {
                newQuery.range(expRel.getRange().getIndex(), expRel.getRange().getSize());
            }
            this.logger.info("Optimizer consume {}ms", (Object)(System.currentTimeMillis() - optimizer));
            return newQuery;
        }
        return expRel;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    class OrCheckVisitor
    implements ExpVisitor {
        boolean hasOr = false;

        OrCheckVisitor() {
        }

        public Object visit(ExpField field) {
            return null;
        }

        public Object visit(ExpCondition rel) {
            if (rel.getOperator() == ExpOperator.OR) {
                this.hasOr = true;
            } else {
                rel.getExpNodes().stream().map(x -> x.accept(this)).collect(Collectors.toList());
            }
            return null;
        }

        public Object visit(ExpValue value) {
            return null;
        }

        public Object visit(ExpBi bi) {
            return null;
        }

        public Object visit(ExpSort expSort) {
            return null;
        }

        public Object visit(ExpRange range) {
            return null;
        }

        public boolean isHasOr() {
            return this.hasOr;
        }
    }
}

