/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer;

import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpBi;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpQuery;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRange;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpSort;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpValue;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpVisitor;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer.ExpConditionOptimizer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class EmptyConditionRemover
implements ExpConditionOptimizer {
    @Override
    public ExpRel transform(ExpContext expContext, ExpRel expRel) {
        if (expRel instanceof ExpQuery) {
            ExpQuery newQuery = new ExpQuery();
            newQuery.project(expRel.getProjects());
            newQuery.sort(expRel.getSorts());
            newQuery.filters(this.optimizer(ExpOperator.OR, expRel.getFilters()));
            if (expRel.getRange() != null) {
                newQuery.range(expRel.getRange().getIndex(), expRel.getRange().getSize());
            }
            return newQuery;
        }
        return expRel;
    }

    private List<ExpNode> optimizer(ExpOperator expOperator, List<ExpNode> oldFilters) {
        if (expOperator == ExpOperator.OR) {
            boolean hasAlwaysTrue = oldFilters.stream().anyMatch(x -> {
                if (x instanceof ExpCondition) {
                    return ((ExpCondition)x).isAlwaysTrue();
                }
                return false;
            });
            if (hasAlwaysTrue) {
                return Collections.singletonList(ExpCondition.alwaysTrue());
            }
            List nonAlways = oldFilters.stream().filter(x -> {
                if (x instanceof ExpCondition) {
                    return !((ExpCondition)x).isAlwaysFalse();
                }
                return false;
            }).collect(Collectors.toList());
            return nonAlways.stream().map(x -> {
                HasEmptyNode hasEmptyNode = new HasEmptyNode();
                x.accept(hasEmptyNode);
                if (hasEmptyNode.hasEmpty) {
                    return this.newCondition((ExpNode)x);
                }
                return x;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (expOperator == ExpOperator.AND) {
            boolean hasAlwaysFalse = oldFilters.stream().anyMatch(x -> {
                if (x instanceof ExpCondition) {
                    return ((ExpCondition)x).isAlwaysFalse();
                }
                return false;
            });
            if (hasAlwaysFalse) {
                return Collections.singletonList(ExpCondition.alwaysFalse());
            }
            List nonAlways = oldFilters.stream().filter(x -> {
                if (x instanceof ExpCondition) {
                    return !((ExpCondition)x).isAlwaysTrue();
                }
                return false;
            }).collect(Collectors.toList());
            return nonAlways.stream().map(x -> {
                HasEmptyNode hasEmptyNode = new HasEmptyNode();
                x.accept(hasEmptyNode);
                if (hasEmptyNode.hasEmpty) {
                    return this.newCondition((ExpNode)x);
                }
                return x;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return oldFilters;
    }

    private ExpNode newCondition(ExpNode expNode) {
        ExpCondition cond = (ExpCondition)expNode;
        List<ExpNode> optimizedConds = this.optimizer(cond.getOperator(), cond.getExpNodes());
        if (optimizedConds.isEmpty()) {
            return null;
        }
        if (optimizedConds.size() == 1) {
            if (((ExpCondition)optimizedConds.get(0)).isAlwaysTrue()) {
                return ExpCondition.alwaysTrue();
            }
            if (((ExpCondition)optimizedConds.get(0)).isAlwaysFalse()) {
                return ExpCondition.alwaysFalse();
            }
        }
        ExpCondition newCond = ExpCondition.call(cond.getOperator(), optimizedConds);
        return newCond;
    }

    @Override
    public int getOrder() {
        return 0;
    }

    class HasEmptyNode
    implements ExpVisitor {
        boolean hasEmpty = false;

        HasEmptyNode() {
        }

        public Object visit(ExpField field) {
            return null;
        }

        public Object visit(ExpCondition rel) {
            if (rel.getOperator() == ExpOperator.AND || rel.getOperator() == ExpOperator.OR) {
                if (rel.getExpNodes().isEmpty()) {
                    this.hasEmpty = true;
                } else {
                    rel.getExpNodes().forEach(x -> x.accept(this));
                }
            } else if (rel.getOperator() == ExpOperator.DUMMY) {
                this.hasEmpty = true;
            }
            return null;
        }

        public Object visit(ExpValue value) {
            return null;
        }

        public Object visit(ExpBi bi) {
            return null;
        }

        public Object visit(ExpSort expSort) {
            return null;
        }

        public Object visit(ExpRange range) {
            return null;
        }
    }
}

