/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer.LazySchemaMap;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IEntityClassSchema
extends AbstractSchema {
    private Logger logger = LoggerFactory.getLogger(IEntityClassSchema.class);
    private MetadataRepository repository;
    private AuthSearcherConfig config;

    public IEntityClassSchema(MetadataRepository repository, AuthSearcherConfig config) {
        this.repository = repository;
        this.config = config;
    }

    protected Map<String, Table> getTableMap() {
        return new LazySchemaMap<String, Table>(code -> this.repository.loadByCode(this.config.getTenant(), this.config.getAppId(), (String)code).map(IEntityClassTable::new).orElseThrow(() -> new RuntimeException("No Related EntityClass Name " + code)));
    }

    private static class IEntityClassTable
    extends AbstractQueryableTable
    implements Table {
        private Logger logger = LoggerFactory.getLogger(IEntityClassTable.class);
        IEntityClass iEntityClass;

        IEntityClassTable(IEntityClass entityClass) {
            super(Object[].class);
            this.iEntityClass = entityClass;
        }

        public RelDataType getRowType(RelDataTypeFactory relDataTypeFactory) {
            IEntityClass entity = this.iEntityClass;
            List fields = entity.fields();
            long createStart = System.currentTimeMillis();
            List names = fields.stream().map(x -> Pair.of((Object)x.name(), (Object)this.fieldTypeToRelDataType(relDataTypeFactory, x.type()))).collect(Collectors.toList());
            long createEnd = System.currentTimeMillis();
            this.logger.info("Type Create Time {}", (Object)(createEnd - createStart));
            RelDataType structType = relDataTypeFactory.createStructType(names);
            this.logger.info("Real Type Create Time {}", (Object)(System.currentTimeMillis() - createEnd));
            return structType;
        }

        private RelDataType fieldTypeToRelDataType(RelDataTypeFactory relDataTypeFactory, FieldType fieldType) {
            return relDataTypeFactory.createJavaType(fieldType.getJavaType());
        }

        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return null;
        }
    }
}

