/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.query.transformer.optimizer.utils;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpBi;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpOperator;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRange;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpSort;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpValue;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.RelBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpTreeToRel {
    private static Logger logger = LoggerFactory.getLogger(ExpTreeToRel.class);

    public static RelNode toRelTree(IEntityClass schema, ExpRel root, FrameworkConfig config) {
        long builderStart = System.currentTimeMillis();
        RelBuilder builder = ExpTreeToRel.getBuilder(config);
        long builderEnd = System.currentTimeMillis();
        logger.info("Builder time {}", (Object)(builderEnd - builderStart));
        long relNodeBuildEnd = System.currentTimeMillis();
        List<ExpNode> filters = root.getFilters();
        logger.info("Builder1 time {}", (Object)(System.currentTimeMillis() - relNodeBuildEnd));
        RelBuilder scan = builder.scan(new String[]{schema.code()});
        logger.info("Builder2 time {}", (Object)(System.currentTimeMillis() - relNodeBuildEnd));
        RelTreeVisitor visitor = new RelTreeVisitor(scan);
        logger.info("Builder3 time {}", (Object)(System.currentTimeMillis() - relNodeBuildEnd));
        RexNode condition = ExpCondition.call(ExpOperator.OR, filters).accept(visitor);
        logger.info("Builder4 time {}", (Object)(System.currentTimeMillis() - relNodeBuildEnd));
        RelNode build = scan.filter(new RexNode[]{condition}).build();
        logger.info("Builder5 time {}", (Object)(System.currentTimeMillis() - relNodeBuildEnd));
        return build;
    }

    private static RelBuilder getBuilder(FrameworkConfig config) {
        long current = System.currentTimeMillis();
        RelBuilder relBuilder = RelBuilder.create((FrameworkConfig)config);
        logger.info("Create Time {}", (Object)(System.currentTimeMillis() - current));
        return relBuilder;
    }

    public static ExpNode toExpTree(RelNode root, List<RelDataTypeField> fields) {
        if (root instanceof LogicalFilter) {
            return (ExpNode)((LogicalFilter)root).getCondition().accept((RexVisitor)new ExpTreeVisitor(fields));
        }
        return ExpCondition.alwaysTrue();
    }

    static class RelTreeVisitor
    implements ExpVisitor<RexNode> {
        private RelBuilder builder;

        public RelTreeVisitor(RelBuilder builder) {
            this.builder = builder;
        }

        @Override
        public RexNode visit(ExpField field) {
            return this.builder.field(field.getName());
        }

        @Override
        public RexNode visit(ExpCondition rel) {
            if (rel.getOperator() == ExpOperator.AND) {
                return this.builder.and((Iterable)rel.getExpNodes().stream().map(x -> x.accept(this)).collect(Collectors.toList()));
            }
            if (rel.getOperator() == ExpOperator.OR) {
                return this.builder.or((Iterable)rel.getExpNodes().stream().map(x -> x.accept(this)).collect(Collectors.toList()));
            }
            if (rel.isAlwaysTrue()) {
                return this.builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.builder.literal((Object)1), this.builder.literal((Object)1)});
            }
            if (rel.isAlwaysFalse()) {
                return this.builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.builder.literal((Object)1), this.builder.literal((Object)0)});
            }
            List<SqlOperator> sqlOperators = this.toSqlOperator(rel.getOperator());
            if (sqlOperators.size() > 0) {
                if (sqlOperators.size() == 2) {
                    if (rel.getExpNodes().size() == 3) {
                        RexNode left = this.builder.call(sqlOperators.get(0), new RexNode[]{rel.getExpNodes().get(0).accept(this), rel.getExpNodes().get(1).accept(this)});
                        RexNode right = this.builder.call(sqlOperators.get(1), new RexNode[]{rel.getExpNodes().get(0).accept(this), rel.getExpNodes().get(2).accept(this)});
                        return this.builder.and(new RexNode[]{left, right});
                    }
                } else {
                    return this.builder.call(sqlOperators.get(0), (Iterable)rel.getExpNodes().stream().map(x -> x.accept(this)).collect(Collectors.toList()));
                }
            }
            throw new RuntimeException("Invalid tree");
        }

        @Override
        public RexNode visit(ExpValue value) {
            return this.builder.literal((Object)value.getStrValue());
        }

        @Override
        public RexNode visit(ExpBi bi) {
            return null;
        }

        @Override
        public RexNode visit(ExpSort expSort) {
            return null;
        }

        @Override
        public RexNode visit(ExpRange range) {
            return null;
        }

        private List<SqlOperator> toSqlOperator(ExpOperator operator) {
            switch (operator) {
                case EQUALS: {
                    return Collections.singletonList(SqlStdOperatorTable.EQUALS);
                }
                case NOT_EQUALS: {
                    return Collections.singletonList(SqlStdOperatorTable.NOT_EQUALS);
                }
                case LIKE: {
                    return Collections.singletonList(SqlStdOperatorTable.LIKE);
                }
                case NOT_IN: {
                    return Collections.singletonList(SqlStdOperatorTable.NOT_IN);
                }
                case IN: {
                    return Collections.singletonList(SqlStdOperatorTable.IN);
                }
                case GREATER_EQUALS: {
                    return Collections.singletonList(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL);
                }
                case GREATER_THAN: {
                    return Collections.singletonList(SqlStdOperatorTable.GREATER_THAN);
                }
                case LESS_EQUALS: {
                    return Collections.singletonList(SqlStdOperatorTable.LESS_THAN_OR_EQUAL);
                }
                case LESS_THAN: {
                    return Collections.singletonList(SqlStdOperatorTable.LESS_THAN);
                }
                case GREATER_EQ_AND_LESS_EQ: {
                    return Arrays.asList(SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, SqlStdOperatorTable.LESS_THAN_OR_EQUAL);
                }
                case GREATER_THAN_AND_LESS_EQ: {
                    return Arrays.asList(SqlStdOperatorTable.GREATER_THAN, SqlStdOperatorTable.LESS_THAN_OR_EQUAL);
                }
                case GREATER_THAN_AND_LESS_THAN: {
                    return Arrays.asList(SqlStdOperatorTable.GREATER_THAN, SqlStdOperatorTable.LESS_THAN);
                }
                case GREATER_EQ_AND_LESS_THAN: {
                    return Arrays.asList(SqlStdOperatorTable.LESS_THAN_OR_EQUAL, SqlStdOperatorTable.LESS_THAN);
                }
            }
            return Collections.emptyList();
        }
    }

    static class ExpTreeVisitor
    implements RexVisitor<ExpNode> {
        List<RelDataTypeField> fields;

        public ExpTreeVisitor(List<RelDataTypeField> fields) {
            this.fields = fields;
        }

        public ExpNode visitInputRef(RexInputRef inputRef) {
            int index = inputRef.getIndex();
            return ExpField.field(this.fields.get(index).getName());
        }

        public ExpNode visitLocalRef(RexLocalRef localRef) {
            return null;
        }

        public ExpNode visitLiteral(RexLiteral literal) {
            return ExpValue.literal((String)literal.getValueAs(String.class));
        }

        private ExpOperator toExpOperator(SqlOperator op) {
            if (op.equals((Object)SqlStdOperatorTable.EQUALS)) {
                return ExpOperator.EQUALS;
            }
            if (op.equals((Object)SqlStdOperatorTable.NOT_EQUALS)) {
                return ExpOperator.NOT_EQUALS;
            }
            if (op.equals((Object)SqlStdOperatorTable.IN)) {
                return ExpOperator.IN;
            }
            if (op.equals((Object)SqlStdOperatorTable.GREATER_THAN)) {
                return ExpOperator.GREATER_THAN;
            }
            if (op.equals((Object)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL)) {
                return ExpOperator.GREATER_EQUALS;
            }
            if (op.equals((Object)SqlStdOperatorTable.LESS_THAN)) {
                return ExpOperator.LESS_THAN;
            }
            if (op.equals((Object)SqlStdOperatorTable.LESS_THAN_OR_EQUAL)) {
                return ExpOperator.LESS_EQUALS;
            }
            if (op.equals((Object)SqlStdOperatorTable.LIKE)) {
                return ExpOperator.LIKE;
            }
            if (op.equals((Object)SqlStdOperatorTable.NOT_IN)) {
                return ExpOperator.NOT_IN;
            }
            return null;
        }

        public ExpNode visitCall(RexCall call) {
            if (call.isA(SqlKind.AND)) {
                return ExpCondition.call(ExpOperator.AND, call.getOperands().stream().map(x -> (ExpNode)x.accept((RexVisitor)this)).collect(Collectors.toList()));
            }
            if (call.isA(SqlKind.OR)) {
                return ExpCondition.call(ExpOperator.OR, call.getOperands().stream().map(x -> (ExpNode)x.accept((RexVisitor)this)).collect(Collectors.toList()));
            }
            ExpOperator expOperator = this.toExpOperator(call.getOperator());
            if (expOperator != null) {
                return ExpCondition.call(expOperator, call.getOperands().stream().map(x -> (ExpNode)x.accept((RexVisitor)this)).collect(Collectors.toList()));
            }
            logger.warn(call.getOperands() + " is not support ");
            throw new RuntimeException(call.getOperands() + " is not support ");
        }

        public ExpNode visitOver(RexOver over) {
            return null;
        }

        public ExpNode visitCorrelVariable(RexCorrelVariable correlVariable) {
            return null;
        }

        public ExpNode visitDynamicParam(RexDynamicParam dynamicParam) {
            return null;
        }

        public ExpNode visitRangeRef(RexRangeRef rangeRef) {
            return null;
        }

        public ExpNode visitFieldAccess(RexFieldAccess fieldAccess) {
            return null;
        }

        public ExpNode visitSubQuery(RexSubQuery subQuery) {
            return null;
        }

        public ExpNode visitTableInputRef(RexTableInputRef fieldRef) {
            return null;
        }

        public ExpNode visitPatternFieldRef(RexPatternFieldRef fieldRef) {
            return null;
        }
    }
}

