/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.query.utils;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.ColumnField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.sdk.FilterNode;
import com.xforceplus.ultraman.oqsengine.sdk.Filters;
import com.xforceplus.ultraman.oqsengine.sdk.Projects;
import com.xforceplus.ultraman.oqsengine.sdk.QueryFieldsUp;
import com.xforceplus.ultraman.oqsengine.sdk.Range;
import com.xforceplus.ultraman.oqsengine.sdk.SelectByTree;
import com.xforceplus.ultraman.oqsengine.sdk.SortNode;
import com.xforceplus.ultraman.oqsengine.sdk.Sorts;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpCondition;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpField;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpNode;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRange;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpSort;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpValue;
import com.xforceplus.ultraman.oqsengine.sdk.util.EntityClassToGrpcConverter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class RelTreeHelper {
    public static SelectByTree relToTree(IEntityClass schema, ExpRel tree, ExpContext context) {
        List<ExpNode> projects = tree.getProjects();
        List<ExpNode> filters = tree.getFilters();
        ExpSort sorts = tree.getSorts();
        ExpRange range = tree.getRange();
        return SelectByTree.newBuilder().setProjects(RelTreeHelper.toProjects(projects, context)).setFilters(RelTreeHelper.toFilters(filters, context)).setSorts(RelTreeHelper.toSorts(sorts, context)).setRange(RelTreeHelper.toRange(range)).setEntity(EntityClassToGrpcConverter.toEntityUp(schema)).build();
    }

    private static Filters toFilters(List<ExpNode> nodes, ExpContext context) {
        List filterNode = nodes.stream().peek(x -> x.setExpContext(context)).map(RelTreeHelper::toFilterNode).filter(Objects::nonNull).collect(Collectors.toList());
        return Filters.newBuilder().addAllNodes(filterNode).build();
    }

    private static FilterNode toFilterNode(ExpNode node) {
        if (node instanceof ExpCondition) {
            if (((ExpCondition)node).isAlwaysTrue()) {
                return null;
            }
            return FilterNode.newBuilder().setNodeType(0).setOperator(FilterNode.Operator.valueOf((String)((ExpCondition)node).getOperator().getShortName())).addAllNodes((Iterable)((ExpCondition)node).getExpNodes().stream().map(RelTreeHelper::toFilterNode).filter(Objects::nonNull).collect(Collectors.toList())).build();
        }
        if (node instanceof ExpValue) {
            return FilterNode.newBuilder().setNodeType(2).setPayload(((ExpValue)node).getStrValue()).build();
        }
        if (node instanceof ExpField) {
            return FilterNode.newBuilder().setNodeType(1).setPayload(((ExpField)node).getName()).build();
        }
        return null;
    }

    private static Projects toProjects(List<ExpNode> projects, ExpContext context) {
        return Projects.newBuilder().addAllQueryFields((Iterable)projects.stream().peek(x -> x.setExpContext(context)).map(RelTreeHelper::toQueryFieldUp).filter(Objects::nonNull).collect(Collectors.toList())).build();
    }

    private static Optional<ColumnField> getColumnField(ExpContext context, String code) {
        if (context != null && context.getSchema() != null) {
            IEntityClassReader schema = context.getSchema();
            return schema.column(code);
        }
        return Optional.empty();
    }

    private static QueryFieldsUp toQueryFieldUp(ExpNode expNode) {
        ExpContext context;
        Optional<ColumnField> column;
        if (expNode instanceof ExpField && (column = RelTreeHelper.getColumnField(context = expNode.getExpContext(), ((ExpField)expNode).getName())).isPresent()) {
            return QueryFieldsUp.newBuilder().setId(column.get().id()).setEntityId(column.get().originEntityClass().id()).setCode(((ExpField)expNode).getName()).build();
        }
        return null;
    }

    private static Sorts toSorts(ExpSort sorts, ExpContext context) {
        return Sorts.newBuilder().addAllSort((Iterable)sorts.getSorts().stream().map(x -> RelTreeHelper.toSortNode(x, context)).filter(Objects::nonNull).collect(Collectors.toList())).build();
    }

    private static SortNode toSortNode(ExpSort.FieldSort sort, ExpContext context) {
        Optional<ColumnField> column = RelTreeHelper.getColumnField(context, sort.getCode());
        return column.map(columnField -> SortNode.newBuilder().setCode(sort.getCode()).setFieldId(columnField.id()).setOrder(sort.getSort() == ExpSort.Sort.ASCEND ? SortNode.Order.asc : SortNode.Order.desc).build()).orElse(null);
    }

    private static Range toRange(ExpRange range) {
        Range.Builder builder = Range.newBuilder();
        if (range.getIndex() != null) {
            builder.setPageIndex(range.getIndex().intValue());
        }
        if (range.getSize() != null) {
            builder.setPageSize(range.getSize().intValue());
        }
        return builder.buildPartial();
    }
}

