/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.NotUsed;
import akka.japi.function.Function;
import akka.stream.javadsl.Flow;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportRecordStringFlow;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportStringTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.NameMapping;
import io.vavr.Tuple2;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class CSVRecordFlow
implements ExportRecordStringFlow {
    @Override
    public Flow<Record, String, NotUsed> getFlow(IEntityClass entityClass, AtomicBoolean isFirstLine, List<NameMapping> nameMapping, List<String> columns, Set<String> filterColumns, ExportStringTransformer transformer, Map<String, Object> context) {
        return Flow.of(Record.class).map((Function & Serializable)record -> {
            StringBuilder sb = new StringBuilder();
            if (isFirstLine.get()) {
                Map map = Optional.ofNullable(nameMapping).map(x -> x.stream().collect(Collectors.toMap(NameMapping::getCode, NameMapping::getText, (a, b) -> a))).orElse(Collections.emptyMap());
                String header = record.stream(filterColumns).sorted(Comparator.comparingInt(field -> columns.indexOf(((IEntityField)field._1()).name()))).map(Tuple2::_1).map(x -> Optional.ofNullable(x).map(y -> {
                    String fieldName = y.name();
                    String name = (String)map.get(fieldName);
                    if (name == null) {
                        return y.cnName();
                    }
                    return name;
                }).orElse("")).collect(Collectors.joining(","));
                sb.append(header);
                sb.append("\n");
                isFirstLine.set(false);
            }
            String line = record.stream(filterColumns).sorted(Comparator.comparingInt(field -> columns.indexOf(((IEntityField)field._1()).name()))).map(x -> {
                IEntityField field = (IEntityField)x._1();
                Object value = x._2();
                return transformer.toString(entityClass, field, value, context);
            }).collect(Collectors.joining(","));
            sb.append(line);
            sb.append("\n");
            return sb.toString();
        });
    }
}

