/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.export.impl;

import akka.NotUsed;
import akka.japi.function.Function;
import akka.stream.ActorMaterializer;
import akka.stream.Graph;
import akka.stream.IOResult;
import akka.stream.Materializer;
import akka.stream.javadsl.Flow;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.util.ByteString;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityErrorExported;
import com.xforceplus.ultraman.oqsengine.sdk.event.EntityExported;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.EntityExportService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportRecordStringFlow;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSink;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportStringTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.NameMapping;
import io.vavr.Tuple2;
import io.vavr.control.Either;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;

public class EntityExportServiceImpl
implements EntityExportService {
    @Autowired
    private ActorMaterializer materializer;
    @Autowired
    private ExportSink exportSink;
    @Autowired
    private ExportRecordStringFlow toStringFlow;
    @Autowired
    private ApplicationEventPublisher publisher;
    @Autowired
    private ExportSource exportService;
    @Autowired
    private ExportStringTransformer stringTransformer;
    private Logger logger = LoggerFactory.getLogger(EntityExportService.class);

    @Override
    public CompletableFuture<Either<String, String>> export(IEntityClass entityClass, ConditionQueryRequest query, String token, String fileName, Map<String, Object> context, String exportType, String appId) {
        Source<Record, NotUsed> source = this.exportService.source(entityClass, query);
        Sink<ByteString, CompletionStage<Tuple2<IOResult, String[]>>> fileSink = this.exportSink.getSink(token, fileName);
        List<NameMapping> nameMapping = query.getMapping();
        List<String> columns = query.getStringKeysOrderedWithUnderScore();
        Set filterColumns = Optional.ofNullable(columns).map(HashSet::new).orElseGet(Collections::emptySet);
        AtomicBoolean isFirstLine = new AtomicBoolean(true);
        Flow<Record, String, NotUsed> flow = this.toStringFlow.getFlow(entityClass, isFirstLine, nameMapping, columns, filterColumns, this.stringTransformer, context);
        try {
            byte[] bom = new byte[]{-17, -69, -65};
            Source bomSource = Source.single((Object)ByteString.fromArray((byte[])bom));
            CompletionStage syncCompleteResult = ((CompletableFuture)((CompletionStage)bomSource.concat((Graph)source.via(flow).map((Function & Serializable)x -> ByteString.fromString((String)x, (Charset)StandardCharsets.UTF_8))).runWith(fileSink, (Materializer)this.materializer)).toCompletableFuture().thenApply(x -> {
                String downloadUrl = this.exportSink.getDownloadUrl((String[])x._2());
                this.publisher.publishEvent((Object)new EntityExported(context, downloadUrl, entityClass, fileName, exportType, appId));
                return Either.right((Object)downloadUrl);
            })).exceptionally(th -> {
                this.publisher.publishEvent((Object)new EntityErrorExported(context, token, th.getMessage(), appId));
                return Either.left((Object)th.getMessage());
            });
            if ("sync".equalsIgnoreCase(exportType)) {
                return syncCompleteResult;
            }
            return CompletableFuture.completedFuture(Either.right((Object)"\u8bf7\u6c42\u5b8c\u6210"));
        }
        catch (Exception ex) {
            this.logger.error("{}", (Throwable)ex);
            return CompletableFuture.completedFuture(Either.left((Object)ex.getMessage()));
        }
    }
}

