/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import akka.grpc.javadsl.SingleResponseRequestBuilder;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.EntityServiceClient;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
import com.xforceplus.ultraman.oqsengine.sdk.SelectByTree;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpRel;
import com.xforceplus.ultraman.oqsengine.sdk.query.transformer.ExpTreeTransformer;
import com.xforceplus.ultraman.oqsengine.sdk.query.utils.RelTreeHelper;
import com.xforceplus.ultraman.oqsengine.sdk.query.validate.ExpTreeValidator;
import com.xforceplus.ultraman.oqsengine.sdk.service.ExecutionService;
import com.xforceplus.ultraman.oqsengine.sdk.service.HandleResultValueService;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import com.xforceplus.xplat.galaxy.framework.context.ContextKeys;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import io.vavr.control.Either;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecutionServiceImpl
implements ExecutionService {
    @Autowired
    private List<ExpTreeTransformer> transformers;
    @Autowired
    private HandleResultValueService handleResultValueService;
    @Autowired
    private List<ExpTreeValidator> validators;
    @Autowired
    private ContextService contextService;
    private Logger logger = LoggerFactory.getLogger(ExecutorService.class);
    @Autowired
    private EntityServiceClient entityServiceClient;

    @Override
    public Either<String, DataCollection<Record>> query(ExpContext context, ExpRel rel) {
        long queryTotalStart = System.currentTimeMillis();
        List orderedTransformers = this.transformers.stream().sorted().collect(Collectors.toList());
        long transformStart = System.currentTimeMillis();
        ExpRel temp = rel;
        for (ExpTreeTransformer treeTransformer : orderedTransformers) {
            temp = treeTransformer.transform(context, temp);
        }
        this.logger.info("Transform consume {}ms", (Object)(System.currentTimeMillis() - transformStart));
        ExpRel newTree = temp;
        long validatorStart = System.currentTimeMillis();
        this.validators.forEach(x -> x.validate(context, newTree).getOrElseThrow(RuntimeException::new));
        this.logger.info("Validator consume {}ms", (Object)(System.currentTimeMillis() - validatorStart));
        String transId = (String)this.contextService.get((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY);
        SingleResponseRequestBuilder requestBuilder = this.entityServiceClient.selectByTreeFilter();
        if (transId != null) {
            this.logger.info("findRecordsByCondition with Transaction id:{} ", (Object)transId);
            requestBuilder = requestBuilder.addHeader("transaction-id", transId);
        }
        SelectByTree selectByTree = RelTreeHelper.relToTree(context.getSchema().getEntityClass(), newTree, context);
        long queryStart = System.currentTimeMillis();
        OperationResult result = (OperationResult)requestBuilder.invoke((Object)selectByTree).toCompletableFuture().join();
        this.logger.info("Query consume {}ms", (Object)(System.currentTimeMillis() - queryStart));
        this.logger.info("Query total consume {}ms", (Object)(System.currentTimeMillis() - queryTotalStart));
        if (result.getCode() == OperationResult.Code.OK) {
            List repList = result.getQueryResultList().stream().map(x -> this.handleResultValueService.toRecord(context.getSchema().getEntityClass(), (EntityUp)x)).collect(Collectors.toList());
            DataCollection dataCollection = new DataCollection(result.getTotalRow(), repList);
            return Either.right(dataCollection);
        }
        return Either.left((Object)result.getMessage());
    }
}

