/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.xforceplus.ultraman.oqsengine.sdk.config.perm.page.PagePermissionClient;
import com.xforceplus.ultraman.oqsengine.sdk.service.PagePermissionService;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.permission.RuleResult;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PagePermissionServiceImpl
implements PagePermissionService {
    @Autowired
    private PagePermissionClient client;
    private Logger logger = LoggerFactory.getLogger(PagePermissionService.class);
    LoadingCache<PermissionKey, List<RuleResult>> cache = Caffeine.newBuilder().maximumSize(1000L).refreshAfterWrite(30L, TimeUnit.SECONDS).build(key -> {
        this.logger.info("[Permission]Get From Real backend with {}", key);
        return this.client.getRules(key.getRoleIds(), key.getPageCode(), key.getAppId(), key.getTenantCode(), key.getPageTenant());
    });

    @Override
    public List<RuleResult> getRuleResults(Long tenantId, Long page, String appId, String pageCode, String tenantCode, String pageTenant, List<Long> roleIds) {
        PermissionKey key = new PermissionKey();
        key.setPage(page);
        key.setTenantId(tenantId);
        key.setRoleIds(roleIds);
        key.setAppId(appId);
        key.setPageCode(pageCode);
        key.setTenantCode(tenantCode);
        key.setPageTenant(pageTenant);
        return (List)this.cache.get((Object)key);
    }

    static class PermissionKey {
        Long tenantId;
        Long page;
        String tenantCode;
        String pageCode;
        String appId;
        String pageTenant;
        List<Long> roleIds;

        PermissionKey() {
        }

        public Long getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(Long tenantId) {
            this.tenantId = tenantId;
        }

        public Long getPage() {
            return this.page;
        }

        public void setPage(Long page) {
            this.page = page;
        }

        public List<Long> getRoleIds() {
            return this.roleIds;
        }

        public void setRoleIds(List<Long> roleIds) {
            this.roleIds = roleIds;
        }

        public String getTenantCode() {
            return this.tenantCode;
        }

        public String getPageCode() {
            return this.pageCode;
        }

        public void setTenantCode(String tenantCode) {
            this.tenantCode = tenantCode;
        }

        public void setPageCode(String pageCode) {
            this.pageCode = pageCode;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getPageTenant() {
            return this.pageTenant;
        }

        public void setPageTenant(String pageTenant) {
            this.pageTenant = pageTenant;
        }

        public String toString() {
            return "PermissionKey{tenantId=" + this.tenantId + ", page=" + this.page + ", tenantCode='" + this.tenantCode + '\'' + ", pageCode='" + this.pageCode + '\'' + ", appId='" + this.appId + '\'' + ", pageTenant='" + this.pageTenant + '\'' + ", roleIds=" + this.roleIds + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PermissionKey that = (PermissionKey)o;
            return Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.page, that.page) && Objects.equals(this.tenantCode, that.tenantCode) && Objects.equals(this.pageCode, that.pageCode) && Objects.equals(this.appId, that.appId) && Objects.equals(this.pageTenant, that.pageTenant) && Objects.equals(this.roleIds, that.roleIds);
        }

        public int hashCode() {
            return Objects.hash(this.tenantId, this.page, this.tenantCode, this.pageCode, this.appId, this.pageTenant, this.roleIds);
        }
    }
}

