/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.service.impl;

import akka.NotUsed;
import akka.japi.function.Function;
import akka.stream.javadsl.Source;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.GeneralRecord;
import com.xforceplus.ultraman.oqsengine.pojo.reader.record.Record;
import com.xforceplus.ultraman.oqsengine.sdk.handler.DefaultEntityServiceHandler;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpContext;
import com.xforceplus.ultraman.oqsengine.sdk.query.dsl.ExpFactory;
import com.xforceplus.ultraman.oqsengine.sdk.service.EntityService;
import com.xforceplus.ultraman.oqsengine.sdk.service.ExecutionService;
import com.xforceplus.ultraman.oqsengine.sdk.service.export.ExportSource;
import com.xforceplus.ultraman.oqsengine.sdk.vo.DataCollection;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionOp;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Conditions;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldCondition;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import io.vavr.control.Either;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceExportSource
implements ExportSource {
    private Logger logger = LoggerFactory.getLogger(ExportSource.class);
    private int step;
    private int maxRetryTimes = 5;
    private ExecutionService executionService;
    private DefaultEntityServiceHandler defaultEntityServiceHandler;
    private ContextService contextService;

    public SequenceExportSource(EntityService entityService, int step, ContextService contextService, ExecutionService executionService) {
        this.executionService = executionService;
        this.step = step;
        this.contextService = contextService;
    }

    @Override
    public Source<Record, NotUsed> source(IEntityClass entityClass, ConditionQueryRequest queryRequest) {
        AtomicInteger cursor = new AtomicInteger(0);
        AtomicInteger error = new AtomicInteger(0);
        AtomicLong lastId = new AtomicLong(0L);
        Map contextMap = null;
        if (this.contextService != null) {
            contextMap = this.contextService.getAll();
        }
        Map finalContextMap = contextMap;
        return Source.repeat((Object)1).flatMapConcat((Function & Serializable)i -> {
            if (this.contextService != null && finalContextMap != null) {
                this.contextService.fromMap(finalContextMap);
            }
            this.logger.info("-----Export {}:{} ---- query {} times ----with last id {}", new Object[]{entityClass.code(), entityClass.id(), cursor.getAndIncrement(), lastId.get()});
            ExpContext expContext = new ExpContext().withSchema(entityClass).withContext(this.contextService.getAll());
            Either<String, DataCollection<Record>> byCondition = this.executionService.query(expContext, ExpFactory.createFrom(queryRequest));
            if (this.contextService != null) {
                this.contextService.clear();
            }
            if (byCondition.isRight()) {
                error.set(0);
                List ret = ((DataCollection)byCondition.get()).getRows();
                this.logger.warn("-----Export {}:{} ---- clear error and found size is {} ----", new Object[]{entityClass.code(), entityClass.id(), ret.size()});
                if (ret.size() < this.step) {
                    LinkedList list = new LinkedList(ret);
                    list.addLast(GeneralRecord.empty());
                    return Source.from(list);
                }
                Record lastRecord = (Record)ret.get(ret.size() - 1);
                if (lastRecord != null) {
                    lastId.set(lastRecord.getId());
                }
                return Source.from(ret);
            }
            this.logger.warn("-----Export {}:{} ---- found error {} ----", new Object[]{entityClass.code(), entityClass.id(), byCondition.getLeft()});
            if (error.getAndIncrement() < this.maxRetryTimes) {
                return Source.empty();
            }
            return Source.single((Object)GeneralRecord.empty());
        }).takeWhile(Record::nonEmpty);
    }

    private ConditionQueryRequest toQueryCondition(ConditionQueryRequest request, int pageSize, Long lastId) {
        request.setPageSize(pageSize);
        request.setPageNo(1);
        request.setSort(null);
        Conditions conditions = request.getConditions();
        LinkedList<Object> newFieldConditions = null;
        newFieldConditions = lastId == 0L ? (conditions == null || conditions.getFields() == null ? new LinkedList() : new LinkedList<FieldCondition>(conditions.getFields())) : (LinkedList)conditions.getFields();
        if (lastId > 0L) {
            newFieldConditions.removeLast();
        }
        FieldCondition condition = new FieldCondition();
        condition.setCode("id");
        condition.setOperation(ConditionOp.gt);
        condition.setValue(Collections.singletonList(lastId.toString()));
        newFieldConditions.add(condition);
        if (conditions == null) {
            conditions = new Conditions();
        }
        conditions.setFields(newFieldConditions);
        request.setConditions(conditions);
        return request;
    }
}

