/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl;

import com.xforceplus.ultraman.metadata.grpc.Api;
import com.xforceplus.ultraman.metadata.grpc.BoUp;
import com.xforceplus.ultraman.metadata.grpc.Field;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldLikeRelationType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldType;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.EntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.sdk.store.RowUtils;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.CurrentVersion;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.SimpleBoItem;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.VersionService;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl.BoNode;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl.DefaultVersionService;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl.tables.ApiTable;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl.tables.BoTable;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl.tables.FieldTable;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl.tables.ModuleTable;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.impl.tables.RelationTable;
import com.xforceplus.ultraman.oqsengine.sdk.util.FieldHelper;
import com.xforceplus.ultraman.oqsengine.sdk.util.VersionUtils;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ApiItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.BoItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.SoloItem;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.delete.RowDeletionBuilder;
import org.apache.metamodel.insert.InsertInto;
import org.apache.metamodel.pojo.MapTableDataProvider;
import org.apache.metamodel.pojo.PojoDataContext;
import org.apache.metamodel.pojo.TableDataProvider;
import org.apache.metamodel.query.builder.SatisfiedWhereBuilder;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;

public class MetadataRepositoryInMemoryImpl
implements MetadataRepository {
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private VersionService versionService;
    private int maxVersion = 3;
    Logger logger = LoggerFactory.getLogger(MetadataRepository.class);

    public MetadataRepositoryInMemoryImpl() {
        this(-1, null);
    }

    public MetadataRepositoryInMemoryImpl(int maxVersion, ApplicationEventPublisher publisher) {
        if (maxVersion > 0) {
            this.maxVersion = maxVersion;
        }
        this.versionService = new DefaultVersionService(this.maxVersion, publisher);
        this.versionService.initVersionedDC(this.maxVersion, this::generateNewDC);
    }

    private UpdateableDataContext generateNewDC() {
        TableDataProvider[] tableDataProviders = (TableDataProvider[])Stream.of(new ModuleTable(), new BoTable(), new ApiTable(), new FieldTable(), new RelationTable()).map(x -> {
            SimpleTableDef tableDef = new SimpleTableDef(x.name(), x.columns());
            return new MapTableDataProvider(tableDef, x.getStore());
        }).toArray(TableDataProvider[]::new);
        return new PojoDataContext("metadata", tableDataProviders);
    }

    private Map<String, ApiItem> toApiItemMap(DataSet apis) {
        HashMap<String, ApiItem> map = new HashMap<String, ApiItem>();
        while (apis.next()) {
            Row row = apis.getRow();
            String code = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
            String url = RowUtils.getRowValue(row, "url").map(String::valueOf).orElse("");
            String method = RowUtils.getRowValue(row, "method").map(String::valueOf).orElse("");
            ApiItem apiItem = new ApiItem(url, method);
            map.put(code, apiItem);
        }
        return map;
    }

    private List<FieldItem> toFieldItemList(DataSet fields) {
        ArrayList<FieldItem> items = new ArrayList<FieldItem>();
        while (fields.next()) {
            Row row = fields.getRow();
            FieldItem fieldItem = new FieldItem();
            fieldItem.setCode(RowUtils.getRowValue(row, "code").map(String::valueOf).orElse(""));
            fieldItem.setDisplayType(RowUtils.getRowValue(row, "displayType").map(String::valueOf).orElse(""));
            fieldItem.setEditable(RowUtils.getRowValue(row, "editable").map(String::valueOf).orElse(""));
            fieldItem.setEnumCode(RowUtils.getRowValue(row, "enumCode").map(String::valueOf).orElse(""));
            fieldItem.setMaxLength(RowUtils.getRowValue(row, "maxLength").map(String::valueOf).orElse(""));
            fieldItem.setName(RowUtils.getRowValue(row, "name").map(String::valueOf).orElse(""));
            fieldItem.setRequired(RowUtils.getRowValue(row, "required").map(String::valueOf).orElse(""));
            fieldItem.setType(RowUtils.getRowValue(row, "fieldType").map(String::valueOf).orElse(""));
            fieldItem.setSearchable(RowUtils.getRowValue(row, "searchable").map(String::valueOf).orElse(""));
            fieldItem.setDictId(RowUtils.getRowValue(row, "dictId").map(String::valueOf).orElse(""));
            fieldItem.setDefaultValue(RowUtils.getRowValue(row, "defaultValue").map(String::valueOf).orElse(""));
            fieldItem.setPrecision(RowUtils.getRowValue(row, "precision").map(String::valueOf).orElse(""));
            fieldItem.setRelationshipEntity(null);
            items.add(fieldItem);
        }
        return items;
    }

    private <T> T read(Supplier<T> supplier) {
        this.rwLock.readLock().lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private void write(Supplier<Void> supplier) {
        this.rwLock.writeLock().lock();
        try {
            supplier.get();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public BoItem getBoDetailById(String id) {
        return this.read(() -> {
            Tuple2<String, UpdateableDataContext> dcTuple = this.versionService.getCurrentVersionDCForBoById(Long.parseLong(id));
            UpdateableDataContext dc = (UpdateableDataContext)dcTuple._2;
            if (dc == null) {
                return null;
            }
            DataSet boDetails = ((SatisfiedWhereBuilder)dc.query().from("bos").selectAll().where("id").eq(id)).execute();
            if (boDetails.next()) {
                Row ds = boDetails.getRow();
                DataSet apis = ((SatisfiedWhereBuilder)dc.query().from("apis").selectAll().where("boId").eq(id)).execute();
                Map<String, ApiItem> apiItemMap = this.toApiItemMap(apis);
                DataSet fields = ((SatisfiedWhereBuilder)dc.query().from("fields").selectAll().where("boId").eq(id)).execute();
                List<FieldItem> fieldItemList = this.toFieldItemList(fields);
                DataSet rels = ((SatisfiedWhereBuilder)dc.query().from("rels").selectAll().where("boId").eq(id)).execute();
                List rows = rels.toRows();
                List<String> relIds = rows.stream().map(x -> RowUtils.getRowValue(x, "joinBoId").map(String::valueOf).orElse("")).collect(Collectors.toList());
                List<FieldItem> relField = this.loadRelationField(rows, row -> {
                    String joinBoId = RowUtils.getRowValue(row, "joinBoId").map(String::valueOf).orElse("");
                    DataSet boDs = ((SatisfiedWhereBuilder)dc.query().from("bos").selectAll().where("id").eq(joinBoId)).execute();
                    if (boDs.next()) {
                        Row bo = boDs.getRow();
                        String boCode = RowUtils.getRowValue(bo, "code").map(String::valueOf).orElse("");
                        SoloItem soloItem = new SoloItem();
                        soloItem.setId(Long.valueOf(joinBoId));
                        return new FieldItem(boCode.concat(".id"), boCode.concat(".id"), FieldType.LONG.getType(), "", "false", "true", "false", null, null, "0", "", "", soloItem);
                    }
                    return null;
                });
                LinkedList<FieldItem> fieldTotalItems = new LinkedList<FieldItem>();
                fieldTotalItems.addAll(fieldItemList);
                fieldTotalItems.addAll(relField);
                BoItem boItem = new BoItem();
                boItem.setApi(apiItemMap);
                boItem.setFields(fieldTotalItems);
                boItem.setParentEntityId(RowUtils.getRowValue(ds, "parentId").map(String::valueOf).orElse(""));
                boItem.setSubEntities(relIds);
                return boItem;
            }
            return null;
        });
    }

    @Override
    public void save(ModuleUpResult moduleUpResult, String tenantId, String appId) {
        this.write(() -> {
            String version = moduleUpResult.getVersion();
            long moduleId = moduleUpResult.getId();
            this.logger.info("------- Version {} Got For {}", (Object)version, (Object)moduleId);
            this.versionService.saveModule(moduleId, version, moduleUpResult.getBoUpsList().stream().flatMap(x -> {
                Stream<BoNode> single = Stream.of(new BoNode(x.getCode(), Long.parseLong(x.getId())));
                Stream<BoNode> nestOne = x.getBoUpsList().stream().map(sub -> new BoNode(sub.getCode(), Long.parseLong(sub.getId())));
                return Stream.concat(single, nestOne);
            }).collect(Collectors.toList()));
            UpdateableDataContext versionedDCForModule = this.versionService.getVersionedDCForModule(moduleId, version);
            moduleUpResult.getBoUpsList().forEach(boUp -> {
                this.clearAllBoIdRelated(boUp.getId(), moduleId, versionedDCForModule);
                this.logger.info("Clear Bo:{}", (Object)boUp.getId());
                this.insertBo(moduleId, (BoUp)boUp, versionedDCForModule);
                this.logger.info("Insert Bo:{}", (Object)boUp.getId());
            });
            return null;
        });
    }

    private Optional<IEntityClass> loadParentEntityClassWithRelation(String boId, UpdateableDataContext dc, String ver) {
        return this.read(() -> Optional.ofNullable(dc).flatMap(x -> {
            DataSet boDs = ((SatisfiedWhereBuilder)dc.query().from("bos").selectAll().where("id").eq(boId)).execute();
            if (boDs.next()) {
                Row row = boDs.getRow();
                String code = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
                List<IEntityField> entityFields = this.loadFields(boId, dc);
                DataSet relDs = ((SatisfiedWhereBuilder)dc.query().from("rels").selectAll().where("boId").eq(boId)).execute();
                List relsRows = relDs.toRows();
                List<Tuple2> relatedEntityClassList = relsRows.stream().map(relRow -> {
                    Optional<String> relatedBoIdOp = RowUtils.getRowValue(relRow, "joinBoId").map(String::valueOf);
                    return relatedBoIdOp.flatMap(relBo -> this.loadRelationEntityClass((String)relBo, (Row)relRow, code, dc, ver));
                }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                LinkedList entityClassList = new LinkedList();
                LinkedList relationList = new LinkedList();
                LinkedList<IEntityField> allFields = new LinkedList<IEntityField>();
                allFields.addAll(entityFields);
                relatedEntityClassList.forEach(tuple -> {
                    entityClassList.add(tuple._2());
                    relationList.add(tuple._1());
                });
                relationList.stream().filter(rel -> FieldLikeRelationType.from((String)rel.getRelationType()).map(FieldLikeRelationType::isOwnerSide).orElse(false)).forEach(rel -> allFields.add(rel.getEntityField()));
                return Optional.of(new EntityClass(Long.valueOf(boId).longValue(), VersionUtils.toVersionInt(ver).intValue(), code, Collections.emptyList(), Collections.emptyList(), null, allFields));
            }
            return Optional.empty();
        }));
    }

    private Optional<IEntityClass> loadParentEntityClassWithoutRelation(String boId, UpdateableDataContext dc, String ver) {
        return this.read(() -> Optional.ofNullable(dc).flatMap(x -> {
            DataSet boDs = ((SatisfiedWhereBuilder)dc.query().from("bos").selectAll().where("id").eq(boId)).execute();
            if (boDs.next()) {
                Row row = boDs.getRow();
                String code = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
                List<IEntityField> entityFields = this.loadFields(boId, dc);
                return Optional.of(new EntityClass(Long.valueOf(boId).longValue(), VersionUtils.toVersionInt(ver).intValue(), code, Collections.emptyList(), Collections.emptyList(), null, entityFields));
            }
            return Optional.empty();
        }));
    }

    private Optional<Tuple2<Relation, IEntityClass>> loadRelationEntityClass(String boId, Row relRow, String mainBoCode, UpdateableDataContext contextDC, String ver) {
        return this.read(() -> {
            String relationType = RowUtils.getRowValue(relRow, "relType").map(String::valueOf).orElse("");
            String name = RowUtils.getRowValue(relRow, "relName").map(String::valueOf).orElse("");
            Long joinBoId = RowUtils.getRowValue(relRow, "joinBoId").map(String::valueOf).map(Long::valueOf).orElse(0L);
            Long relId = RowUtils.getRowValue(relRow, "id").map(String::valueOf).map(Long::valueOf).orElse(0L);
            return this.findOneById("bos", boId, contextDC).map(row -> {
                Optional parentEntityClass = RowUtils.getRowValue(row, "parentId").map(String::valueOf).flatMap(x -> this.loadParentEntityClassWithoutRelation((String)x, contextDC, ver));
                String subCode = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
                LinkedList<IEntityField> listFields = new LinkedList<IEntityField>();
                Relation relation = new Relation(relId, name, joinBoId.longValue(), subCode, mainBoCode, relationType);
                FieldLikeRelationType.from((String)relationType).ifPresent(x -> {
                    IEntityField relField = x.getField(relation);
                    relation.setEntityField(relField);
                    if (!x.isOwnerSide()) {
                        listFields.add(relField);
                    }
                });
                listFields.addAll(this.loadFields(boId, contextDC));
                EntityClass entityClass = new EntityClass(Long.valueOf(boId).longValue(), VersionUtils.toVersionInt(ver).intValue(), subCode, Collections.emptyList(), Collections.emptyList(), (IEntityClass)parentEntityClass.orElse(null), listFields);
                return Tuple.of((Object)relation, (Object)entityClass);
            });
        });
    }

    @Override
    public Optional<IEntityClass> loadByCode(String tenantId, String appCode, String boCode) {
        return this.read(() -> {
            Tuple2<String, UpdateableDataContext> currentVersionDCForBoByCode = this.versionService.getCurrentVersionDCForBoByCode(boCode);
            UpdateableDataContext dc = Optional.ofNullable(currentVersionDCForBoByCode).map(Tuple2::_2).orElse(null);
            return Optional.ofNullable(dc).flatMap(contextDC -> this.loadByCode(tenantId, appCode, boCode, (UpdateableDataContext)contextDC, (String)currentVersionDCForBoByCode._1()));
        });
    }

    public Optional<IEntityClass> loadByCode(String tenantId, String appCode, String boCode, UpdateableDataContext contextDC, String ver) {
        return this.read(() -> {
            DataSet boDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("code").eq(boCode)).execute();
            if (boDs.next()) {
                return this.toEntityClass(boDs.getRow(), contextDC, ver);
            }
            return Optional.empty();
        });
    }

    @Override
    public List<IEntityClass> findSubEntitiesById(String tenantId, String appId, String parentId) {
        return this.read(() -> Optional.ofNullable(this.versionService.getCurrentVersionDCForBoById(Long.parseLong(parentId))).map(x -> this.findSubEntitiesById(tenantId, appId, parentId, (UpdateableDataContext)x._2(), (String)x._1())).orElseGet(Collections::emptyList));
    }

    @Override
    public List<IEntityClass> findSubEntitiesById(String tenantId, String appId, String parentId, String version) {
        return this.read(() -> Optional.ofNullable(this.versionService.getVersionedDCForBoById(Long.parseLong(parentId), version)).map(x -> this.findSubEntitiesById(tenantId, appId, parentId, (UpdateableDataContext)x, version)).orElseGet(Collections::emptyList));
    }

    private List<IEntityClass> findSubEntitiesById(String tenantId, String appId, String parentId, UpdateableDataContext contextDC, String ver) {
        return this.read(() -> {
            DataSet boDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("parentId").eq(parentId)).execute();
            List rows = boDs.toRows();
            return rows.stream().map(row -> this.toEntityClass((Row)row, contextDC, ver)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        });
    }

    private List<IEntityClass> findSubEntitiesByCode(String tenantId, String appId, String parentCode, UpdateableDataContext contextDC) {
        return this.read(() -> {
            DataSet boDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("code").eq(parentCode)).execute();
            if (boDs.next()) {
                String id = RowUtils.getRowValue(boDs.getRow(), "id").map(String::valueOf).orElse("");
                return this.findSubEntitiesById(tenantId, appId, id);
            }
            return Collections.emptyList();
        });
    }

    @Override
    public List<IEntityClass> findSubEntitiesByCode(String tenantId, String appId, String parentCode) {
        return this.read(() -> {
            Tuple2<String, UpdateableDataContext> currentVersionDCForBoByCode = this.versionService.getCurrentVersionDCForBoByCode(parentCode);
            UpdateableDataContext contextDC = (UpdateableDataContext)currentVersionDCForBoByCode._2();
            return Optional.ofNullable(contextDC).map(x -> this.findSubEntitiesByCode(tenantId, appId, parentCode, (UpdateableDataContext)x)).orElseGet(Collections::emptyList);
        });
    }

    @Override
    public List<IEntityClass> findSubEntitiesByCode(String tenantId, String appId, String parentCode, String version) {
        return this.read(() -> {
            UpdateableDataContext contextDC = this.versionService.getVersionedDCForBoByCode(parentCode, version);
            return Optional.ofNullable(contextDC).map(x -> this.findSubEntitiesByCode(tenantId, appId, parentCode, (UpdateableDataContext)x)).orElseGet(Collections::emptyList);
        });
    }

    @Override
    public Optional<IEntityClass> load(String tenantId, String appCode, String boId) {
        return this.read(() -> {
            Tuple2<String, UpdateableDataContext> currentVersionDCForBoById = this.versionService.getCurrentVersionDCForBoById(Long.parseLong(boId));
            UpdateableDataContext dc = Optional.ofNullable(currentVersionDCForBoById).map(Tuple2::_2).orElse(null);
            return Optional.ofNullable(dc).flatMap(x -> this.load(tenantId, appCode, boId, (UpdateableDataContext)x, (String)currentVersionDCForBoById._1()));
        });
    }

    @Override
    public Optional<IEntityClass> load(String tenantId, String appCode, String boId, String version) {
        return this.read(() -> {
            UpdateableDataContext contextDc = this.versionService.getVersionedDCForBoById(Long.parseLong(boId), version);
            return Optional.ofNullable(contextDc).flatMap(x -> this.load(tenantId, appCode, boId, (UpdateableDataContext)x, version));
        });
    }

    @Override
    public Optional<IEntityClass> loadByCode(String tenantId, String appCode, String boCode, String version) {
        return this.read(() -> {
            UpdateableDataContext contextDc = this.versionService.getVersionedDCForBoByCode(boCode, version);
            return Optional.ofNullable(contextDc).flatMap(x -> this.loadByCode(tenantId, appCode, boCode, (UpdateableDataContext)x, version));
        });
    }

    private Optional<IEntityClass> load(String tenantId, String appCode, String boId, UpdateableDataContext contextDC, String ver) {
        this.logger.debug("load class {} with contextDC {}", (Object)boId, (Object)contextDC);
        return this.read(() -> {
            DataSet boDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("id").eq(boId)).execute();
            if (boDs.next()) {
                return this.toEntityClass(boDs.getRow(), contextDC, ver);
            }
            return Optional.empty();
        });
    }

    private Optional<IEntityClass> toEntityClass(Row row, UpdateableDataContext contextDC, String ver) {
        return this.read(() -> {
            String code = RowUtils.getRowValue(row, "code").map(String::valueOf).orElse("");
            String boId = RowUtils.getRowValue(row, "id").map(String::valueOf).orElse("0");
            String name = RowUtils.getRowValue(row, "name").map(String::valueOf).orElse("");
            List<IEntityField> fields = this.loadFields(boId, contextDC);
            String parentId = RowUtils.getRowValue(row, "parentId").map(String::valueOf).orElse("");
            Optional<IEntityClass> parentEntityClassOp = this.loadParentEntityClassWithRelation(parentId, contextDC, ver);
            LinkedList relationRows = new LinkedList();
            DataSet relDs = ((SatisfiedWhereBuilder)contextDC.query().from("rels").selectAll().where("boId").eq(boId)).execute();
            relationRows.addAll(relDs.toRows());
            LinkedList relsRows = relationRows;
            List<Tuple2> relatedEntityClassList = relsRows.stream().map(relRow -> {
                Optional<String> relatedBoIdOp = RowUtils.getRowValue(relRow, "joinBoId").map(String::valueOf);
                return relatedBoIdOp.flatMap(x -> this.loadRelationEntityClass((String)x, (Row)relRow, code, contextDC, ver));
            }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            LinkedList entityClassList = new LinkedList();
            LinkedList relationList = new LinkedList();
            LinkedList<IEntityField> allFields = new LinkedList<IEntityField>();
            allFields.addAll(fields);
            relatedEntityClassList.forEach(tuple -> {
                entityClassList.add(tuple._2());
                relationList.add(tuple._1());
            });
            relationList.stream().filter(x -> FieldLikeRelationType.from((String)x.getRelationType()).map(FieldLikeRelationType::isOwnerSide).orElse(false)).forEach(x -> allFields.add(x.getEntityField()));
            EntityClass entityClass = new EntityClass(Long.valueOf(boId), VersionUtils.toVersionInt(ver).intValue(), code, name, relationList, entityClassList, (IEntityClass)parentEntityClassOp.orElse(null), allFields);
            return Optional.of(entityClass);
        });
    }

    private <U> List<U> loadRelationField(List<Row> relations, Function<Row, U> mapper) {
        return relations.stream().filter(row -> RowUtils.getRowValue(row, "relType").map(String::valueOf).filter(type -> type.equalsIgnoreCase("onetoone") || type.equalsIgnoreCase("manytoone")).isPresent()).map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Table getTable(String tableName, UpdateableDataContext contextDC) {
        return this.read(() -> contextDC.getTableByQualifiedLabel("metadata." + tableName));
    }

    private Optional<Row> findOneById(String tableName, String id, UpdateableDataContext dc) {
        return this.read(() -> {
            DataSet ds = ((SatisfiedWhereBuilder)dc.query().from(tableName).selectAll().where("id").eq(id)).execute();
            if (ds.next()) {
                return Optional.ofNullable(ds.getRow());
            }
            return Optional.empty();
        });
    }

    @Override
    public void clearAllBoIdRelated(String boId, Long moduleId, UpdateableDataContext dc) {
        this.write(() -> {
            UpdateSummary updateSummary = dc.executeUpdate(callback -> {
                ((RowDeletionBuilder)callback.deleteFrom(this.getTable("bos", dc)).where("id").eq(boId)).execute();
                ((RowDeletionBuilder)callback.deleteFrom(this.getTable("apis", dc)).where("boId").eq(boId)).execute();
                ((RowDeletionBuilder)callback.deleteFrom(this.getTable("fields", dc)).where("boId").eq(boId)).execute();
                ((RowDeletionBuilder)callback.deleteFrom(this.getTable("rels", dc)).where("boId").eq(boId)).execute();
            });
            return null;
        });
    }

    @Override
    public SimpleBoItem findOneById(String boId) {
        return this.read(() -> {
            Tuple2<String, UpdateableDataContext> currentVersionDCForBoById = this.versionService.getCurrentVersionDCForBoById(Long.parseLong(boId));
            UpdateableDataContext dc = Optional.ofNullable(currentVersionDCForBoById).map(Tuple2::_2).orElse(null);
            return Optional.ofNullable(dc).map(x -> this.findOneById(boId, dc)).orElse(null);
        });
    }

    @Override
    public SimpleBoItem findOneById(String boId, String version) {
        return this.read(() -> {
            UpdateableDataContext dc = this.versionService.getVersionedDCForBoById(Long.parseLong(boId), version);
            return Optional.ofNullable(dc).map(x -> this.findOneById(boId, dc)).orElse(null);
        });
    }

    public SimpleBoItem findOneById(String boId, UpdateableDataContext contextDC) {
        return this.read(() -> {
            DataSet boDs = ((SatisfiedWhereBuilder)contextDC.query().from("bos").selectAll().where("id").eq(boId)).execute();
            if (boDs.next()) {
                SimpleBoItem simpleBoItem = new SimpleBoItem();
                Row row = boDs.getRow();
                simpleBoItem.setCode(RowUtils.getRowValue(row, "code").map(String::valueOf).orElse(""));
                simpleBoItem.setParentId(RowUtils.getRowValue(row, "parentId").map(String::valueOf).orElse(""));
                simpleBoItem.setId(boId);
                simpleBoItem.setCname(RowUtils.getRowValue(row, "name").map(String::valueOf).orElse(""));
                return simpleBoItem;
            }
            return null;
        });
    }

    @Override
    public List<IEntityClass> findAllEntities() {
        return this.read(() -> this.versionService.getBoModuleMapping().entrySet().stream().map(x -> {
            Long boId = ((BoNode)x.getKey()).getId();
            LinkedList value = (LinkedList)x.getValue();
            String version = (String)((Tuple2)value.getLast())._2();
            UpdateableDataContext versionedDCForBoId = this.versionService.getVersionedDCForBoById(boId, version);
            this.logger.debug("CurrentContext is {}", (Object)versionedDCForBoId);
            return Optional.ofNullable(versionedDCForBoId).flatMap(dc -> this.load("", "", String.valueOf(boId), (UpdateableDataContext)dc, version));
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }

    private List<IEntityClass> findAllEntities(UpdateableDataContext contextDC, String ver) {
        return this.read(() -> {
            DataSet boDs = contextDC.query().from("bos").selectAll().execute();
            List rows = boDs.toRows();
            return rows.stream().map(x -> this.toEntityClass((Row)x, contextDC, ver)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        });
    }

    @Override
    public CurrentVersion currentVersion() {
        return this.read(() -> new CurrentVersion(this.versionService.getCurrentVersion()));
    }

    private void insertBoTable(String id, String moduleId, String code, String parentId, String name, UpdateableDataContext contextDC) {
        this.write(() -> {
            InsertInto insert = (InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)new InsertInto(this.getTable("bos", contextDC)).value("id", (Object)id)).value("code", (Object)code)).value("parentId", (Object)parentId)).value("name", (Object)name)).value("moduleId", (Object)moduleId);
            contextDC.executeUpdate((UpdateScript)insert);
            return null;
        });
    }

    private void insertBo(long moduleId, BoUp boUp, UpdateableDataContext contextDC) {
        this.write(() -> {
            this.insertBoTable(boUp.getId(), String.valueOf(moduleId), boUp.getCode(), boUp.getParentBoId(), boUp.getName(), contextDC);
            boUp.getRelationsList().forEach(rel -> {
                InsertInto insertRel = (InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)new InsertInto(this.getTable("rels", contextDC)).value("id", (Object)rel.getId())).value("boId", (Object)rel.getBoId())).value("joinBoId", (Object)rel.getJoinBoId())).value("identity", (Object)rel.getIdentity())).value("relType", (Object)rel.getRelationType())).value("relName", (Object)rel.getRelName());
                contextDC.executeUpdate((UpdateScript)insertRel);
            });
            boUp.getApisList().forEach(api -> this.insertApi((Api)api, boUp.getId(), contextDC));
            boUp.getFieldsList().forEach(field -> this.insertField((Field)field, boUp.getId(), contextDC));
            boUp.getBoUpsList().stream().filter(relatedBo -> !this.findOneById("bos", relatedBo.getId(), contextDC).isPresent()).forEach(relatedBo -> {
                this.insertBoTable(relatedBo.getId(), String.valueOf(moduleId), relatedBo.getCode(), relatedBo.getParentBoId(), relatedBo.getName(), contextDC);
                relatedBo.getApisList().forEach(api -> this.insertApi((Api)api, relatedBo.getId(), contextDC));
                relatedBo.getFieldsList().forEach(field -> this.insertField((Field)field, relatedBo.getId(), contextDC));
            });
            return null;
        });
    }

    private void insertField(Field field, String boId, UpdateableDataContext contextDC) {
        this.write(() -> {
            String editable = field.getEditable();
            String searchable = field.getSearchable();
            String identifier = field.getIdentifier();
            if ("1".equals(editable)) {
                editable = "true";
            }
            if ("1".equals(searchable)) {
                searchable = "true";
            }
            if ("1".equals(identifier)) {
                identifier = "true";
            }
            InsertInto insert = (InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)((InsertInto)new InsertInto(this.getTable("fields", contextDC)).value("boId", (Object)boId)).value("id", (Object)field.getId())).value("code", (Object)field.getCode())).value("displayType", (Object)field.getDisplayType())).value("editable", (Object)editable)).value("enumCode", (Object)field.getEnumCode())).value("maxLength", (Object)field.getMaxLength())).value("name", (Object)field.getName())).value("required", (Object)field.getRequired())).value("fieldType", (Object)field.getFieldType())).value("searchable", (Object)searchable)).value("dictId", (Object)field.getDictId())).value("defaultValue", (Object)field.getDefaultValue())).value("precision", (Object)String.valueOf(field.getPrecision()))).value("identifier", (Object)identifier)).value("validateRule", (Object)field.getValidateRule());
            contextDC.executeUpdate((UpdateScript)insert);
            return null;
        });
    }

    private void insertApi(Api api, String boId, UpdateableDataContext dc) {
        this.write(() -> {
            InsertInto insert = (InsertInto)((InsertInto)((InsertInto)((InsertInto)new InsertInto(this.getTable("apis", dc)).value("boId", (Object)boId)).value("url", (Object)api.getUrl())).value("code", (Object)api.getCode())).value("method", (Object)api.getMethod());
            dc.executeUpdate((UpdateScript)insert);
            return null;
        });
    }

    private List<IEntityField> loadFields(String id, UpdateableDataContext dc) {
        return this.read(() -> {
            DataSet fieldDs = ((SatisfiedWhereBuilder)dc.query().from("fields").selectAll().where("boId").eq(id)).execute();
            return fieldDs.toRows().stream().map(FieldHelper::toEntityClassField).collect(Collectors.toList());
        });
    }
}

