/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.util;

import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionOp;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Conditions;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.EntityItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldCondition;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldSort;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.NameMapping;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.SubEntityItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.SubFieldCondition;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ConditionQueryRequestHelper {
    public static ConditionQueryRequest build(List<Long> ids, ConditionQueryRequest condition) {
        if (ids == null) {
            return condition;
        }
        ConditionQueryRequest newRequest = ConditionQueryRequestHelper.copyOrNew(condition);
        Conditions conditions = newRequest.getConditions();
        FieldCondition idCondition = new FieldCondition();
        idCondition.setCode("id");
        idCondition.setOperation(ConditionOp.in);
        idCondition.setValue(ids.stream().map(Object::toString).collect(Collectors.toList()));
        if (conditions == null) {
            List<FieldCondition> fieldConditions = Collections.singletonList(idCondition);
            Conditions newConditions = new Conditions();
            newConditions.setFields(fieldConditions);
            newRequest.setConditions(newConditions);
        } else {
            List<FieldCondition> fields = conditions.getFields();
            List fieldConditions = Optional.ofNullable(fields).map(LinkedList::new).orElseGet(LinkedList::new);
            fieldConditions.add(idCondition);
            conditions.setFields(fieldConditions);
        }
        return newRequest;
    }

    public static ConditionQueryRequest copyOrNew(ConditionQueryRequest condition) {
        EntityItem entity;
        List<FieldSort> sort;
        List<NameMapping> mapping;
        ConditionQueryRequest result = new ConditionQueryRequest();
        if (condition == null) {
            return result;
        }
        Conditions conditions = condition.getConditions();
        if (conditions != null) {
            Conditions newConditions = new Conditions();
            if (conditions.getFields() != null) {
                newConditions.setFields(new LinkedList<FieldCondition>(conditions.getFields()));
            }
            if (conditions.getEntities() != null) {
                newConditions.setEntities(new LinkedList<SubFieldCondition>(conditions.getEntities()));
            }
            result.setConditions(newConditions);
        }
        if ((mapping = condition.getMapping()) != null) {
            result.setMapping(new LinkedList<NameMapping>(mapping));
        }
        if ((sort = condition.getSort()) != null) {
            result.setSort(new LinkedList<FieldSort>(sort));
        }
        if ((entity = condition.getEntity()) != null) {
            EntityItem newItem = new EntityItem();
            List<SubEntityItem> entities = entity.getEntities();
            List<String> fields = entity.getFields();
            if (entities != null) {
                newItem.setEntities(new LinkedList<SubEntityItem>(entities));
            }
            if (fields != null) {
                newItem.setFields(new LinkedList<String>(fields));
            }
            result.setEntity(newItem);
        }
        result.setPageSize(condition.getPageSize());
        result.setPageNo(condition.getPageNo());
        return result;
    }
}

