/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.util;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Condition;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionOperator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.ColumnField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionOp;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Conditions;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldCondition;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.SubFieldCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryTransformer {
    private Logger logger = LoggerFactory.getLogger(QueryTransformer.class);

    public com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions toConditions(IEntityClass mainClass, IEntityClassReader reader, ConditionQueryRequest request) {
        Conditions conditions = request.getConditions();
        List<FieldCondition> fields = conditions.getFields();
        List<SubFieldCondition> entities = conditions.getEntities();
        List conditionsMain = fields.stream().map(x -> {
            String code = x.getCode();
            return this.toOneConditions(reader.column(code), (FieldCondition)x, mainClass);
        }).collect(Collectors.toList());
        List conditionsSubs = entities.stream().flatMap(x -> x.getFields().stream().map(y -> this.toOneConditions(reader.column(x.getCode() + "." + y.getCode()), (FieldCondition)y, mainClass))).collect(Collectors.toList());
        ArrayList conditionsAll = new ArrayList(conditionsMain);
        conditionsAll.addAll(conditionsSubs);
        return conditionsAll.stream().reduce(com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions.buildEmtpyConditions(), (a, b) -> a.addAnd(b, false));
    }

    private boolean isRelatedField(ColumnField columnField, IEntityClass mainClass) {
        IEntityClass entityClass = columnField.originEntityClass();
        if (mainClass.extendEntityClass() != null) {
            return mainClass.id() != entityClass.id() && mainClass.extendEntityClass().id() != entityClass.id();
        }
        return entityClass.id() != mainClass.id();
    }

    private List<IValue> toTypedValue(IEntityField entityField, String value) {
        return entityField.type().toTypedValue(entityField, value).map(Collections::singletonList).orElseGet(Collections::emptyList);
    }

    private com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions toOneConditions(Optional<ColumnField> fieldOp, FieldCondition fieldCondition, IEntityClass mainClass) {
        com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions conditions = null;
        if (fieldOp.isPresent()) {
            ColumnField columnField;
            ConditionOp op = fieldCondition.getOperation();
            ColumnField originField = columnField = fieldOp.get();
            List nonNullValueList = fieldCondition.getValue().stream().filter(Objects::nonNull).collect(Collectors.toList());
            if (nonNullValueList.isEmpty()) {
                throw new RuntimeException("Field " + columnField + " Value is Missing");
            }
            switch (op) {
                case eq: {
                    conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.EQUALS, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case ne: {
                    conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.NOT_EQUALS, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case ge: {
                    conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.GREATER_THAN_EQUALS, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case gt: {
                    conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.GREATER_THAN, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case ge_le: {
                    if (nonNullValueList.size() > 1) {
                        Condition left = new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.GREATER_THAN_EQUALS, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0]));
                        Condition right = new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.LESS_THAN_EQUALS, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(1)).toArray(new IValue[0]));
                        conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(left).addAnd(right);
                        break;
                    }
                    this.logger.warn("required value more then 2, fallback to ge");
                    conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.GREATER_THAN_EQUALS, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case gt_le: {
                    if (nonNullValueList.size() > 1) {
                        Condition left = new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.GREATER_THAN, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0]));
                        Condition right = new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.LESS_THAN_EQUALS, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(1)).toArray(new IValue[0]));
                        conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(left).addAnd(right);
                        break;
                    }
                    this.logger.warn("required value more then 2, fallback to gt");
                    conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.GREATER_THAN, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case ge_lt: {
                    if (nonNullValueList.size() > 1) {
                        Condition left = new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.GREATER_THAN_EQUALS, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0]));
                        Condition right = new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.LESS_THAN, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(1)).toArray(new IValue[0]));
                        conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(left).addAnd(right);
                        break;
                    }
                    this.logger.warn("required value more then 2, fallback to ge");
                    conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.GREATER_THAN_EQUALS, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case gt_lt: {
                    if (nonNullValueList.size() > 1) {
                        Condition left = new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.GREATER_THAN, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0]));
                        Condition right = new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.LESS_THAN, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(1)).toArray(new IValue[0]));
                        conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(left).addAnd(right);
                        break;
                    }
                    this.logger.warn("required value more then 2, fallback to ge");
                    conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.GREATER_THAN_EQUALS, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case le: {
                    conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.LESS_THAN_EQUALS, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case lt: {
                    conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.LESS_THAN, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
                case in: {
                    conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.MULTIPLE_EQUALS, (IValue[])nonNullValueList.stream().flatMap(x -> this.toTypedValue((IEntityField)fieldOp.get(), (String)x).stream()).toArray(IValue[]::new)));
                    break;
                }
                case ni: {
                    if (nonNullValueList.size() == 1) {
                        conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.NOT_EQUALS, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                        break;
                    }
                    com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions finalConditions = conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.NOT_EQUALS, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    nonNullValueList.stream().skip(1L).forEach(arg_0 -> this.lambda$toOneConditions$6(finalConditions, columnField, mainClass, (IEntityField)originField, fieldOp, arg_0));
                    conditions = finalConditions;
                    break;
                }
                case like: {
                    conditions = new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, (IEntityField)originField, ConditionOperator.LIKE, this.toTypedValue((IEntityField)fieldOp.get(), (String)nonNullValueList.get(0)).toArray(new IValue[0])));
                    break;
                }
            }
        }
        if (conditions == null) {
            throw new RuntimeException("Condition is invalid " + fieldCondition);
        }
        return conditions;
    }

    private /* synthetic */ void lambda$toOneConditions$6(com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions finalConditions, ColumnField columnField, IEntityClass mainClass, IEntityField originField, Optional fieldOp, String x) {
        finalConditions.addAnd(new com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions(new Condition(this.isRelatedField(columnField, mainClass) ? columnField.originEntityClass() : null, originField, ConditionOperator.NOT_EQUALS, this.toTypedValue((IEntityField)fieldOp.get(), x).toArray(new IValue[0]))), false);
    }
}

