/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.config.init;

import akka.japi.function.Creator;
import akka.japi.function.Function;
import akka.stream.ActorMaterializer;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.javadsl.AsPublisher;
import akka.stream.javadsl.Sink;
import com.xforceplus.ultraman.config.ConfigurationEngine;
import com.xforceplus.ultraman.config.json.JsonConfigNode;
import com.xforceplus.ultraman.metadata.grpc.Base;
import com.xforceplus.ultraman.metadata.grpc.CheckServiceClient;
import com.xforceplus.ultraman.metadata.grpc.ModuleUpResult;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.store.repository.MetadataRepository;
import com.xforceplus.xplat.galaxy.grpc.client.LongConnect;
import io.reactivex.Observable;
import java.io.Serializable;
import java.time.Duration;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.annotation.Order;

@Order
public class ModuleInitService
implements InitializingBean {
    private Logger logger = LoggerFactory.getLogger(ModuleInitService.class);
    private final CheckServiceClient checkServiceClient;
    private final ActorMaterializer mat;
    private final AuthSearcherConfig config;
    private final ApplicationEventPublisher publisher;
    @Autowired
    MetadataRepository store;
    @Value(value="${xplat.oqsengine.sdk.init-size:5}")
    private Integer size;
    @Value(value="${xplat.oqsengine.sdk.init-time:10}")
    private Integer time;
    @Autowired
    private ConfigurationEngine<ModuleUpResult, JsonConfigNode> moduleConfigEngine;

    public ModuleInitService(CheckServiceClient checkServiceClient, ActorMaterializer mat, AuthSearcherConfig config, ApplicationEventPublisher publisher) {
        this.checkServiceClient = checkServiceClient;
        this.mat = mat;
        this.config = config;
        this.publisher = publisher;
    }

    public void afterPropertiesSet() throws Exception {
        Base.Authorization request = Base.Authorization.newBuilder().setAppId(this.config.getAppId()).setEnv(this.config.getEnv()).setTenantId(this.config.getTenant()).build();
        Publisher moduleService = (Publisher)LongConnect.safeSource((int)2, (int)20, (Creator & Serializable)() -> this.checkServiceClient.checkStreaming(request)).log("ModuleService").groupedWithin(this.size.intValue(), Duration.ofSeconds(this.time.intValue())).map((Function & Serializable)x -> {
            this.logger.info("Got module size {}", (Object)x.size());
            return x;
        }).runWith((Graph)Sink.asPublisher((AsPublisher)AsPublisher.WITH_FANOUT), (Materializer)this.mat);
        this.moduleConfigEngine.registerSource(Observable.fromPublisher((Publisher)moduleService).concatMap(Observable::fromIterable));
    }
}

