/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.config.init;

import com.alibaba.fastjson.JSON;
import com.xforceplus.ultraman.config.ConfigurationEngine;
import com.xforceplus.ultraman.config.event.ChangeList;
import com.xforceplus.ultraman.config.json.JsonConfigNode;
import com.xforceplus.ultraman.oqsengine.pojo.auth.Authorization;
import com.xforceplus.ultraman.oqsengine.pojo.dto.UltForm;
import com.xforceplus.ultraman.oqsengine.sdk.config.AuthSearcherConfig;
import com.xforceplus.ultraman.oqsengine.sdk.config.ExternalServiceConfig;
import com.xforceplus.ultraman.oqsengine.sdk.config.init.ConfigType;
import com.xforceplus.ultraman.oqsengine.sdk.event.config.ConfigChangeEvent;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Response;
import io.reactivex.Observable;
import java.util.List;
import java.util.stream.Collectors;
import javax.naming.directory.NoSuchAttributeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Order(value=2)
public class UltFormInitService
implements InitializingBean {
    final Logger logger = LoggerFactory.getLogger(UltFormInitService.class);
    @Autowired
    private AuthSearcherConfig config;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ConfigurationEngine<UltForm, JsonConfigNode> formConfigEngine;
    @Autowired
    private ApplicationEventPublisher eventPublisher;

    public void afterPropertiesSet() throws Exception {
        this.logger.info("begin init forms config");
        String accessUri = null;
        try {
            accessUri = ExternalServiceConfig.PfcpAccessUri();
        }
        catch (NoSuchAttributeException e) {
            e.printStackTrace();
        }
        String url = String.format("%s/forms/init", accessUri);
        Authorization auth = new Authorization();
        auth.setAppId(Long.valueOf(Long.parseLong(this.config.getAppId())));
        auth.setEnv(this.config.getEnv());
        Response result = new Response();
        try {
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity authorizeEntity = new HttpEntity((Object)auth, (MultiValueMap)headers);
            result = (Response)this.restTemplate.postForObject(url, (Object)authorizeEntity, Response.class, new Object[0]);
            if (result.getResult() != null) {
                List ultPages = (List)result.getResult();
                List collect = ultPages.stream().map(x -> (UltForm)JSON.parseObject((String)JSON.toJSONString((Object)x), UltForm.class)).collect(Collectors.toList());
                this.formConfigEngine.registerSource(Observable.fromIterable(collect));
                this.formConfigEngine.getObservable().subscribe(x -> this.eventPublisher.publishEvent((Object)new ConfigChangeEvent(ConfigType.FORM.name(), (ChangeList)x)));
                this.logger.info("init forms config success");
            }
        }
        catch (Exception e) {
            this.logger.info("init forms config faild {}", (Throwable)e);
        }
    }
}

