/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.steady;

import com.baomidou.mybatisplus.extension.service.IService;
import com.xforceplus.ultraman.bocp.gen.annotation.BoService;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class StaticServerLoader
implements SmartInitializingSingleton {
    private String packageName;
    private ApplicationContext context;
    public Map<String, Tuple2<Class, IService>> iServiceMap = new ConcurrentHashMap<String, Tuple2<Class, IService>>();

    public StaticServerLoader(String packageName, ApplicationContext context) {
        this.packageName = packageName;
        this.context = context;
    }

    public void loadService() {
        this.findIService();
    }

    public Tuple2<Class, IService> getService(Long id) {
        return this.iServiceMap.get(id.toString());
    }

    public void afterSingletonsInstantiated() {
        this.loadService();
    }

    private IService findIService() {
        Set candidateComponents = this.getScanner().findCandidateComponents(this.packageName);
        for (BeanDefinition candidateComponent : candidateComponents) {
            try {
                Class<?>[] interfaces;
                Class<?> clazz = Class.forName(candidateComponent.getBeanClassName());
                if (!IService.class.isAssignableFrom(clazz) || (interfaces = clazz.getInterfaces()).length <= 0) continue;
                Class<?> interfaceClazz = interfaces[0];
                BoService annotation = (BoService)AnnotationUtils.getAnnotation(clazz, BoService.class);
                Map beansOfType = this.context.getBeansOfType(interfaceClazz);
                if (beansOfType.isEmpty()) continue;
                Class param = null;
                try {
                    param = (Class)((ParameterizedType)((Class)clazz.getGenericInterfaces()[0]).getGenericInterfaces()[0]).getActualTypeArguments()[0];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Class finalParam = param;
                beansOfType.entrySet().stream().findFirst().ifPresent(x -> this.iServiceMap.put(annotation.value(), (Tuple2<Class, IService>)Tuple.of((Object)finalParam, (Object)((IService)x.getValue()))));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected ClassPathScanningCandidateComponentProvider getScanner() {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(BoService.class));
        return provider;
    }
}

