/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.transactional;

import akka.grpc.javadsl.SingleResponseRequestBuilder;
import com.xforceplus.ultraman.oqsengine.sdk.EntityServiceClient;
import com.xforceplus.ultraman.oqsengine.sdk.OperationResult;
import com.xforceplus.ultraman.oqsengine.sdk.TransactionUp;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransaction;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransactionManager;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.OqsTransactionalAOP;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.TransactionCommitException;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.TransactionCreateErrorException;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.TransactionWrapperException;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.TransactionalExistsException;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.TransactionalNotExistsException;
import com.xforceplus.ultraman.oqsengine.sdk.transactional.annotation.Propagation;
import com.xforceplus.xplat.galaxy.framework.context.ContextKeys;
import com.xforceplus.xplat.galaxy.framework.context.ContextService;
import java.util.Arrays;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransactionManager
implements OqsTransactionManager {
    private Logger logger = LoggerFactory.getLogger(OqsTransactionManager.class);
    private ContextService contextService;
    private EntityServiceClient entityServiceClient;

    public DefaultTransactionManager(ContextService contextService, EntityServiceClient entityServiceClient) {
        this.contextService = contextService;
        this.entityServiceClient = entityServiceClient;
    }

    @Override
    public OqsTransaction getCurrent() {
        Stack oqsTransactions = (Stack)this.contextService.get((ContextService.ContextKey)OqsTransactionalAOP.TransactionKey.TRANSACTION_STACK);
        if (oqsTransactions == null) {
            this.contextService.set((ContextService.ContextKey)OqsTransactionalAOP.TransactionKey.TRANSACTION_STACK, new Stack());
            oqsTransactions = (Stack)this.contextService.get((ContextService.ContextKey)OqsTransactionalAOP.TransactionKey.TRANSACTION_STACK);
        }
        return oqsTransactions.isEmpty() ? null : (OqsTransaction)oqsTransactions.peek();
    }

    private void pushNewTransaction(OqsTransaction oqsTransaction) {
        Stack oqsTransactions = (Stack)this.contextService.get((ContextService.ContextKey)OqsTransactionalAOP.TransactionKey.TRANSACTION_STACK);
        if (oqsTransactions == null) {
            this.contextService.set((ContextService.ContextKey)OqsTransactionalAOP.TransactionKey.TRANSACTION_STACK, new Stack());
            oqsTransactions = (Stack)this.contextService.get((ContextService.ContextKey)OqsTransactionalAOP.TransactionKey.TRANSACTION_STACK);
        }
        oqsTransactions.push(oqsTransaction);
    }

    private void popTransaction() {
        Stack oqsTransactions = (Stack)this.contextService.get((ContextService.ContextKey)OqsTransactionalAOP.TransactionKey.TRANSACTION_STACK);
        if (oqsTransactions != null) {
            oqsTransactions.pop();
        }
    }

    public OqsTransaction createNewTransaction(int timeout) {
        SingleResponseRequestBuilder builder = this.entityServiceClient.begin().addHeader("timeout", String.valueOf(timeout));
        OperationResult result = (OperationResult)builder.invoke((Object)TransactionUp.newBuilder().build()).toCompletableFuture().join();
        if (result.getCode() != OperationResult.Code.OK) {
            throw new TransactionCreateErrorException(result.getMessage());
        }
        this.logger.info("Transaction create success with id:{}", (Object)result.getTransactionResult());
        OqsTransaction transaction = new OqsTransaction();
        transaction.setId(result.getTransactionResult());
        return transaction;
    }

    public void commit(String transactionalKey) {
        CompletionStage commit = this.entityServiceClient.commit().invoke((Object)TransactionUp.newBuilder().setId(transactionalKey).build());
        OperationResult result = (OperationResult)commit.toCompletableFuture().join();
        if (result.getCode() != OperationResult.Code.OK) {
            throw new TransactionCommitException(result.getMessage());
        }
        this.logger.info("transaction {} committed", (Object)transactionalKey);
    }

    private Boolean isTriggerRollBack(Throwable throwable, Class<? extends Throwable>[] noRollBackForClass, Class<? extends Throwable>[] rollBackForClass) {
        boolean noRollBack = false;
        boolean rollBack = true;
        if (noRollBackForClass != null && noRollBackForClass.length > 0) {
            noRollBack = Arrays.stream(noRollBackForClass).anyMatch(x -> x == throwable.getClass());
        }
        if (rollBackForClass != null && rollBackForClass.length > 0) {
            rollBack = Arrays.stream(rollBackForClass).anyMatch(x -> x == throwable.getClass());
        }
        return !noRollBack && rollBack;
    }

    private void rollBack(String transactionalKey) {
        this.logger.info("Roll back {}", (Object)transactionalKey);
        try {
            this.entityServiceClient.rollBack().invoke((Object)TransactionUp.newBuilder().setId(transactionalKey).build()).toCompletableFuture().join();
        }
        catch (Throwable rollbackEx) {
            this.logger.error("Rollback Transaction {} failed", (Object)rollbackEx.getMessage());
        }
    }

    private void logCurrentTransaction() {
        Stack stack = (Stack)this.contextService.get((ContextService.ContextKey)OqsTransactionalAOP.TransactionKey.TRANSACTION_STACK);
        this.logger.info("Transaction stack {}", (Object)stack);
    }

    private <T> T doTransactional(Callable<T> callable, OqsTransaction transaction, OqsTransaction previewTransaction, Class<? extends Throwable>[] noRollBackForClass, Class<? extends Throwable>[] rollBackForClass, boolean isOwner) throws Throwable {
        try {
            this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY, (Object)transaction.getId());
            T output = callable.call();
            boolean isRollBack = transaction.isRollBack();
            if (isRollBack) {
                if (isOwner) {
                    this.rollBack(transaction.getId());
                }
                T t = output;
                return t;
            }
            if (isOwner) {
                this.commit(transaction.getId());
                transaction.setCommit(true);
            }
            T t = output;
            return t;
        }
        catch (Throwable throwable) {
            Throwable rootCause = throwable;
            if (throwable instanceof TransactionWrapperException) {
                rootCause = rootCause.getCause();
            }
            if (this.isTriggerRollBack(rootCause, noRollBackForClass, rollBackForClass).booleanValue()) {
                this.logger.info("Trigger Transaction {} Rollback with ex {}", (Object)transaction.getId(), (Object)rootCause);
                if (!isOwner) {
                    transaction.setRollBack(true);
                } else {
                    this.rollBack(transaction.getId());
                }
            }
            throw rootCause;
        }
        finally {
            if (previewTransaction != null) {
                this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY, (Object)previewTransaction.getId());
            } else {
                this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T transactionExecution(Propagation propagation, int timeout, Class<? extends Throwable>[] noRollBackForClass, Class<? extends Throwable>[] rollBackForClass, Callable<T> callable) throws Throwable {
        OqsTransaction currentTransaction = this.getCurrent();
        T output = null;
        switch (propagation) {
            case REQUIRED: {
                if (currentTransaction == null) {
                    OqsTransaction newTransaction = this.createNewTransaction(timeout);
                    this.pushNewTransaction(newTransaction);
                    try {
                        output = this.doTransactional(callable, newTransaction, null, noRollBackForClass, rollBackForClass, true);
                        break;
                    }
                    finally {
                        this.popTransaction();
                    }
                }
                output = this.doTransactional(callable, currentTransaction, currentTransaction, noRollBackForClass, rollBackForClass, false);
                break;
            }
            case REQUIRES_NEW: {
                OqsTransaction newTransaction = this.createNewTransaction(timeout);
                this.pushNewTransaction(newTransaction);
                try {
                    output = this.doTransactional(callable, newTransaction, currentTransaction, noRollBackForClass, rollBackForClass, true);
                    break;
                }
                finally {
                    this.popTransaction();
                }
            }
            case MANDATORY: {
                if (currentTransaction == null) {
                    throw new TransactionalNotExistsException();
                }
                output = this.doTransactional(callable, currentTransaction, currentTransaction, noRollBackForClass, rollBackForClass, false);
                break;
            }
            case NOT_SUPPORTED: {
                this.contextService.set((ContextService.ContextKey)ContextKeys.StringKeys.TRANSACTION_KEY, null);
                output = callable.call();
                break;
            }
            case NEVER: {
                if (currentTransaction != null) {
                    throw new TransactionalExistsException();
                }
                output = callable.call();
                break;
            }
            case SUPPORTS: {
                if (currentTransaction == null) {
                    output = callable.call();
                    break;
                }
                output = this.doTransactional(callable, currentTransaction, currentTransaction, noRollBackForClass, rollBackForClass, false);
                break;
            }
        }
        this.logCurrentTransaction();
        return output;
    }
}

