/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.sdk.util;

import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Condition;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ConditionOperator;
import com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.ValueConditionNode;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityClass;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.impl.Relation;
import com.xforceplus.ultraman.oqsengine.pojo.dto.sort.Sort;
import com.xforceplus.ultraman.oqsengine.pojo.dto.values.IValue;
import com.xforceplus.ultraman.oqsengine.pojo.page.Page;
import com.xforceplus.ultraman.oqsengine.pojo.reader.IEntityClassReader;
import com.xforceplus.ultraman.oqsengine.pojo.utils.IEntityClassHelper;
import com.xforceplus.ultraman.oqsengine.sdk.ConditionsUp;
import com.xforceplus.ultraman.oqsengine.sdk.EntityUp;
import com.xforceplus.ultraman.oqsengine.sdk.FieldConditionUp;
import com.xforceplus.ultraman.oqsengine.sdk.FieldSortUp;
import com.xforceplus.ultraman.oqsengine.sdk.FieldUp;
import com.xforceplus.ultraman.oqsengine.sdk.QueryFieldsUp;
import com.xforceplus.ultraman.oqsengine.sdk.RelationUp;
import com.xforceplus.ultraman.oqsengine.sdk.SelectByCondition;
import com.xforceplus.ultraman.oqsengine.sdk.ValueUp;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.ConditionQueryRequest;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.Conditions;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.EntityItem;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldCondition;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.FieldSort;
import com.xforceplus.ultraman.oqsengine.sdk.vo.dto.SubFieldCondition;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EntityClassToGrpcConverter {
    public static EntityUp toEntityUp(IEntityClass entityClass) {
        return EntityClassToGrpcConverter.toEntityUpBuilder(entityClass, null).build();
    }

    public static EntityUp toEntityUp(IEntityClass entityClass, long id) {
        return EntityClassToGrpcConverter.toEntityUpBuilder(entityClass, id).build();
    }

    public static EntityUp toRawEntityUp(IEntityClass entity) {
        return EntityUp.newBuilder().setId(entity.id()).setCode(entity.code()).addAllFields((Iterable)entity.fields().stream().map(EntityClassToGrpcConverter::toFieldUp).collect(Collectors.toList())).build();
    }

    public static EntityUp toEntityUp(IEntityClass entityClass, Long id, List<ValueUp> valueList) {
        EntityUp.Builder builder = EntityClassToGrpcConverter.toEntityUpBuilder(entityClass, id);
        builder.addAllValues(valueList);
        return builder.build();
    }

    public static SelectByCondition toSelectByCondition(IEntityClass entityClass, EntityItem entityItem, com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions conditions, Sort sort, Page page) {
        SelectByCondition.Builder select = SelectByCondition.newBuilder();
        if (page != null) {
            select.setPageNo(Long.valueOf(page.getIndex()).intValue());
            select.setPageSize(Long.valueOf(page.getPageSize()).intValue());
        }
        if (sort != null) {
            select.addSort(EntityClassToGrpcConverter.toSortUp(sort.getField(), sort.isAsc()));
        }
        select.setEntity(EntityClassToGrpcConverter.toEntityUp(entityClass));
        if (conditions != null) {
            select.setConditions(EntityClassToGrpcConverter.toConditionsUp(conditions));
        }
        if (entityItem != null) {
            select.addAllQueryFields(EntityClassToGrpcConverter.toQueryFields(entityClass, entityItem));
        }
        return select.build();
    }

    public static SelectByCondition toSelectByCondition(IEntityClass entityClass, List<Long> ids, ConditionQueryRequest condition) {
        SelectByCondition.Builder select = SelectByCondition.newBuilder();
        if (condition.getPageNo() != null) {
            select.setPageNo(condition.getPageNo().intValue());
        }
        if (condition.getPageSize() != null) {
            select.setPageSize(condition.getPageSize().intValue());
        }
        if (condition.getConditions() != null) {
            select.setConditions(EntityClassToGrpcConverter.toConditionsUp(entityClass, condition.getConditions()));
        }
        if (condition.getSort() != null) {
            select.addAllSort(EntityClassToGrpcConverter.toSortUp(condition.getSort()));
        }
        select.setEntity(EntityClassToGrpcConverter.toEntityUp(entityClass));
        EntityItem entityItem = condition.getEntity();
        if (entityItem != null) {
            select.addAllQueryFields(EntityClassToGrpcConverter.toQueryFields(entityClass, entityItem));
        }
        if (ids != null) {
            select.addAllIds(ids);
        }
        return select.build();
    }

    public static SelectByCondition toSelectByCondition(IEntityClass entityClass, ConditionQueryRequest condition, ConditionsUp conditionsUp) {
        SelectByCondition.Builder select = SelectByCondition.newBuilder();
        if (condition != null && condition.getPageNo() != null) {
            select.setPageNo(condition.getPageNo().intValue());
        }
        if (condition != null && condition.getPageSize() != null) {
            select.setPageSize(condition.getPageSize().intValue());
        }
        if (condition != null && condition.getConditions() != null) {
            select.setConditions(conditionsUp);
        }
        if (condition != null && condition.getSort() != null) {
            select.addAllSort(EntityClassToGrpcConverter.toSortUp(condition.getSort()));
        }
        select.setEntity(EntityClassToGrpcConverter.toEntityUp(entityClass));
        EntityItem entityItem = condition.getEntity();
        if (entityItem != null) {
            select.addAllQueryFields(EntityClassToGrpcConverter.toQueryFields(entityClass, entityItem));
        }
        return select.build();
    }

    public static SelectByCondition toUpdateSelection(IEntityClass entityClass, Supplier<EntityUp> entityUpSupplier, ConditionQueryRequest condition, ConditionsUp conditionsUp) {
        SelectByCondition.Builder select = SelectByCondition.newBuilder();
        if (condition != null && condition.getPageNo() != null) {
            select.setPageNo(condition.getPageNo().intValue());
        }
        if (condition != null && condition.getPageSize() != null) {
            select.setPageSize(condition.getPageSize().intValue());
        }
        if (condition != null && condition.getConditions() != null) {
            select.setConditions(conditionsUp);
        }
        if (condition != null && condition.getSort() != null) {
            select.addAllSort(EntityClassToGrpcConverter.toSortUp(condition.getSort()));
        }
        select.setEntity(entityUpSupplier.get());
        EntityItem entityItem = condition.getEntity();
        if (entityItem != null) {
            select.addAllQueryFields(EntityClassToGrpcConverter.toQueryFields(entityClass, entityItem));
        }
        return select.build();
    }

    public static EntityUp.Builder toEntityUpBuilder(IEntityClass entityClass, Long id) {
        EntityUp.Builder builder = EntityUp.newBuilder();
        if (entityClass.extendEntityClass() != null) {
            IEntityClass parent = entityClass.extendEntityClass();
            EntityUp parentUp = EntityClassToGrpcConverter.toRawEntityUp(parent);
            builder.setExtendEntityClass(parentUp);
        }
        if (id != null) {
            builder.setObjId(id.longValue());
        }
        builder.addAllRelation((Iterable)entityClass.relations().stream().map(rel -> {
            RelationUp.Builder relation = RelationUp.newBuilder();
            if (rel.getEntityField() != null) {
                relation.setEntityField(EntityClassToGrpcConverter.toFieldUp(rel.getEntityField()));
            }
            relation.setName(Optional.ofNullable(rel.getName()).orElse(""));
            relation.setRelationType(rel.getRelationType());
            if (rel.isIdentity()) {
                relation.setIdentity(rel.isIdentity());
            }
            relation.setRelatedEntityClassId(rel.getEntityClassId());
            return relation.build();
        }).collect(Collectors.toList()));
        builder.setId(entityClass.id()).setCode(entityClass.code()).addAllFields((Iterable)entityClass.fields().stream().map(EntityClassToGrpcConverter::toFieldUp).collect(Collectors.toList()));
        if (entityClass.entityClasss() != null && !entityClass.entityClasss().isEmpty()) {
            builder.addAllEntityClasses((Iterable)entityClass.entityClasss().stream().map(EntityClassToGrpcConverter::toRawEntityUp).collect(Collectors.toList()));
        }
        return builder;
    }

    private static List<QueryFieldsUp> toQueryFields(IEntityClass entityClass, EntityItem entityItem) {
        IEntityClassReader reader = new IEntityClassReader(entityClass, new IEntityClass[0]);
        Stream fieldsUp = Optional.ofNullable(entityItem).map(EntityItem::getFields).orElseGet(Collections::emptyList).stream();
        Stream fieldsUpFromRelatedEntities = Optional.ofNullable(entityItem).map(EntityItem::getEntities).orElseGet(Collections::emptyList).stream().flatMap(subEntityItem -> subEntityItem.getFields().stream().map(x -> subEntityItem.getCode() + "." + x));
        return Stream.concat(fieldsUp, fieldsUpFromRelatedEntities).map(arg_0 -> ((IEntityClassReader)reader).column(arg_0)).filter(Optional::isPresent).map(Optional::get).map(column -> QueryFieldsUp.newBuilder().setCode(column.name()).setId(column.id()).build()).collect(Collectors.toList());
    }

    public static Optional<IEntityField> getKeyFromRelation(IEntityClass entityClass, String key) {
        return entityClass.relations().stream().filter(x -> x.getName().equals(key)).map(Relation::getEntityField).findFirst();
    }

    public static Optional<IEntityField> getKeyFromEntityClass(IEntityClass entityClass, String key) {
        return entityClass.field(key);
    }

    public static Optional<IEntityField> getKeyFromParent(IEntityClass entityClass, String key) {
        return Optional.ofNullable(entityClass.extendEntityClass()).flatMap(x -> x.field(key));
    }

    private static FieldSortUp toSortUp(IEntityField field, boolean isAsc) {
        return FieldSortUp.newBuilder().setCode(field.name()).setOrder(isAsc ? FieldSortUp.Order.asc : FieldSortUp.Order.desc).build();
    }

    private static List<FieldSortUp> toSortUp(List<FieldSort> sort) {
        return sort.stream().map(x -> FieldSortUp.newBuilder().setCode(x.getField()).setOrder(FieldSortUp.Order.valueOf((String)x.getOrder())).build()).collect(Collectors.toList());
    }

    private static ConditionsUp toConditionsUp(IEntityClass entityClass, Conditions conditions) {
        ConditionsUp.Builder conditionsUpBuilder = ConditionsUp.newBuilder();
        Stream<Optional> fieldInMainStream = Optional.ofNullable(conditions.getFields()).orElseGet(Collections::emptyList).stream().map(fieldCondition -> EntityClassToGrpcConverter.toFieldCondition(entityClass, fieldCondition));
        Stream fieldInRelationStream = conditions.getEntities().stream().flatMap(entityCondition -> EntityClassToGrpcConverter.toFieldConditionFromRel(entityClass, entityCondition));
        conditionsUpBuilder.addAllFields((Iterable)Stream.concat(fieldInMainStream, fieldInRelationStream).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        return conditionsUpBuilder.build();
    }

    private static ConditionsUp toConditionsUp(com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions conditions) {
        ConditionsUp.Builder conditionsUpBuilder = ConditionsUp.newBuilder();
        conditionsUpBuilder.addAllFields((Iterable)conditions.collect().stream().filter(com.xforceplus.ultraman.oqsengine.pojo.dto.conditions.Conditions::isValueNode).map(x -> ((ValueConditionNode)x).getCondition()).map(EntityClassToGrpcConverter::toFieldCondition).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        return conditionsUpBuilder.build();
    }

    private static FieldConditionUp.Op toConditionOp(ConditionOperator conditionOperator) {
        FieldConditionUp.Op op;
        switch (conditionOperator) {
            case GREATER_THAN: {
                op = FieldConditionUp.Op.gt;
                break;
            }
            case GREATER_THAN_EQUALS: {
                op = FieldConditionUp.Op.ge;
                break;
            }
            case LIKE: {
                op = FieldConditionUp.Op.like;
                break;
            }
            case EQUALS: {
                op = FieldConditionUp.Op.eq;
                break;
            }
            case NOT_EQUALS: {
                op = FieldConditionUp.Op.ne;
                break;
            }
            case LESS_THAN_EQUALS: {
                op = FieldConditionUp.Op.le;
                break;
            }
            case LESS_THAN: {
                op = FieldConditionUp.Op.lt;
                break;
            }
            default: {
                op = FieldConditionUp.Op.eq;
            }
        }
        return op;
    }

    private static Optional<FieldConditionUp> toFieldCondition(Condition condition) {
        IEntityField field = condition.getField();
        IValue value = condition.getFirstValue();
        ConditionOperator operator = condition.getOperator();
        if (value == null || field == null || operator == null) {
            return Optional.empty();
        }
        FieldConditionUp fieldCondition = FieldConditionUp.newBuilder().setCode(field.name()).setOperation(EntityClassToGrpcConverter.toConditionOp(operator)).addValues(value.valueToString()).setField(EntityClassToGrpcConverter.toFieldUp(field)).build();
        return Optional.of(fieldCondition);
    }

    private static Optional<FieldConditionUp> toFieldCondition(IEntityClass entityClass, FieldCondition fieldCondition) {
        Optional fieldOp = IEntityClassHelper.findFieldByCode((IEntityClass)entityClass, (String)fieldCondition.getCode());
        return fieldOp.map(x -> FieldConditionUp.newBuilder().setCode(fieldCondition.getCode()).setOperation(Optional.ofNullable(fieldCondition.getOperation()).map(Enum::name).map(FieldConditionUp.Op::valueOf).orElse(FieldConditionUp.Op.eq)).addAllValues((Iterable)Optional.ofNullable(fieldCondition.getValue()).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).collect(Collectors.toList())).setField(EntityClassToGrpcConverter.toFieldUp((IEntityField)fieldOp.get())).build());
    }

    private static Stream<? extends Optional<FieldConditionUp>> toFieldConditionFromRel(IEntityClass entityClass, SubFieldCondition entityCondition) {
        return entityClass.relations().stream().map(rel -> {
            Optional<FieldCondition> fieldConditionOp = entityCondition.getFields().stream().filter(enc -> {
                String code = entityCondition.getCode() + "." + enc.getCode();
                return rel.getEntityField().name().equalsIgnoreCase(code);
            }).findFirst();
            return fieldConditionOp.map(fieldCon -> Tuple.of((Object)fieldCon, (Object)rel));
        }).map(tuple -> tuple.map(EntityClassToGrpcConverter::toFieldCondition));
    }

    private static FieldConditionUp toFieldCondition(Tuple2<FieldCondition, Relation> tuple) {
        FieldCondition fieldCondition = (FieldCondition)tuple._1();
        IEntityField entityField = ((Relation)tuple._2()).getEntityField();
        return FieldConditionUp.newBuilder().setCode(fieldCondition.getCode()).setOperation(FieldConditionUp.Op.valueOf((String)fieldCondition.getOperation().name())).addAllValues((Iterable)Optional.ofNullable(fieldCondition.getValue()).orElseGet(Collections::emptyList)).setField(EntityClassToGrpcConverter.toFieldUp(entityField)).build();
    }

    public static FieldUp toFieldUp(IEntityField field) {
        FieldUp.Builder builder = FieldUp.newBuilder().setCode(field.name()).setFieldType(field.type().name()).setId(field.id());
        if (field.config() != null) {
            builder.setSearchable(String.valueOf(field.config().isSearchable()));
            builder.setMaxLength(String.valueOf(field.config().getMax()));
            builder.setMinLength(String.valueOf(field.config().getMin()));
            builder.setPrecision(field.config().getPrecision());
            builder.setIdentifier(field.config().isIdentifie());
        }
        return builder.build();
    }
}

