/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.status.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.ultraman.oqsengine.pojo.cdc.metrics.CDCAckMetrics;
import com.xforceplus.ultraman.oqsengine.pojo.cdc.metrics.CDCMetrics;
import com.xforceplus.ultraman.oqsengine.status.CDCStatusService;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.TimeGauge;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDCStatusServiceImpl
implements CDCStatusService {
    private static final String DEFAULT_CDC_METRICS_KEY = "com.xforceplus.ultraman.oqsengine.status.cdc.metrics";
    private static final String DEFAULT_HEART_BEAT_KEY = "com.xforceplus.ultraman.oqsengine.status.cdc.heartBeat";
    private static final String DEFAULT_NOT_READY_KEY = "com.xforceplus.ultraman.oqsengine.status.cdc.notReady";
    private static final String DEFAULT_CDC_ACK_METRICS_KEY = "com.xforceplus.ultraman.oqsengine.status.cdc.ack";
    private static final String DEFAULT_CDC_SKIPS_KEY = "com.xforceplus.ultraman.oqsengine.status.cdc.skips";
    final Logger logger = LoggerFactory.getLogger(CDCStatusServiceImpl.class);
    @Resource(name="redisClientState")
    private RedisClient redisClient;
    @Resource
    private ObjectMapper objectMapper;
    private StatefulRedisConnection<String, String> connect;
    private String metricsKey;
    private String ackKey;
    private String heartBeatKey;
    private String notReadyKey;
    private long lastHeartBeatValue = -1L;
    private long lastNotReadyValue = -1L;
    private AtomicLong cdcSyncTime = new AtomicLong(0L);
    private TimeGauge.Builder<AtomicLong> cdcSyncTimeGauge;
    private AtomicLong cdcExecutedCountGauge;
    private AtomicLong cdcNotReadyCommitIdGauge;

    public CDCStatusServiceImpl() {
        this(DEFAULT_CDC_METRICS_KEY, DEFAULT_CDC_ACK_METRICS_KEY, DEFAULT_HEART_BEAT_KEY, DEFAULT_NOT_READY_KEY);
    }

    public CDCStatusServiceImpl(String metricsKey, String ack, String heartBeat, String notReady) {
        this.metricsKey = metricsKey;
        if (this.metricsKey == null || this.metricsKey.isEmpty()) {
            throw new IllegalArgumentException("The cdc status metrics is invalid.");
        }
        this.ackKey = ack;
        if (this.ackKey == null || this.ackKey.isEmpty()) {
            throw new IllegalArgumentException("The ack key is invalid.");
        }
        this.heartBeatKey = heartBeat;
        if (this.heartBeatKey == null || this.heartBeatKey.isEmpty()) {
            throw new IllegalArgumentException("The heartBeatKey is invalid.");
        }
        this.notReadyKey = notReady;
        if (this.notReadyKey == null || this.notReadyKey.isEmpty()) {
            throw new IllegalArgumentException("The notReadyKey is invalid.");
        }
    }

    @PostConstruct
    public void init() {
        this.connect = this.redisClient.connect();
        RedisCommands commands = this.connect.sync();
        commands.clientSetname((Object)"oqs.cdc");
        this.cdcSyncTimeGauge = TimeGauge.builder((String)"oqs.cdc.sync.delay.latency", (Object)this.cdcSyncTime, (TimeUnit)TimeUnit.MILLISECONDS, AtomicLong::get);
        this.cdcExecutedCountGauge = (AtomicLong)Metrics.gauge((String)"oqs.cdc.sync.executed.count", (Number)new AtomicLong(0L));
        this.cdcSyncTimeGauge.register((MeterRegistry)Metrics.globalRegistry);
        this.cdcNotReadyCommitIdGauge = (AtomicLong)Metrics.gauge((String)"oqs.cdc.not.ready.commit", (Number)new AtomicLong(this.lastNotReadyValue));
    }

    @PreDestroy
    public void destroy() {
        this.connect.close();
    }

    @Override
    public boolean heartBeat() {
        block2: {
            RedisCommands commands = this.connect.sync();
            try {
                commands.incr((Object)this.heartBeatKey);
            }
            catch (RedisCommandExecutionException ex) {
                if (!"ERR increment or decrement would overflow".equals(ex.getMessage())) break block2;
                commands.set((Object)this.heartBeatKey, (Object)Long.toString(0L));
            }
        }
        return true;
    }

    @Override
    public void notReady(long commitId) {
        this.cdcNotReadyCommitIdGauge.set(commitId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAlive() {
        RedisCommands commands = this.connect.sync();
        String value = (String)commands.get((Object)this.heartBeatKey);
        if (value == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No heartbeat data for object found. Default is CDC alive.");
            }
            return true;
        }
        long now = Long.parseLong(value);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("The current heartbeat is {}, and the final heartbeat is {}.", (Object)now, (Object)this.lastHeartBeatValue);
        }
        try {
            if (now != this.lastHeartBeatValue) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lastHeartBeatValue = now;
        }
    }

    @Override
    public boolean saveUnCommit(CDCMetrics cdcMetrics) {
        return this.save(cdcMetrics, this.metricsKey);
    }

    @Override
    public Optional<CDCMetrics> getUnCommit() {
        return this.get(this.metricsKey, CDCMetrics.class);
    }

    @Override
    public boolean saveAck(CDCAckMetrics ackMetrics) {
        try {
            boolean bl = this.save(ackMetrics, this.ackKey);
            return bl;
        }
        finally {
            this.cdcSyncTime.set(ackMetrics.getTotalUseTime());
            this.cdcExecutedCountGauge.set(ackMetrics.getExecuteRows());
        }
    }

    @Override
    public Optional<CDCAckMetrics> getAck() {
        return this.get(this.ackKey, CDCAckMetrics.class);
    }

    private boolean save(Object obj, String key) {
        String json = null;
        try {
            json = this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        RedisCommands commands = this.connect.sync();
        String res = commands.set((Object)key, (Object)json);
        return "OK".equals(res);
    }

    private <T> Optional<T> get(String key, Class<T> clazz) {
        RedisCommands commands = this.connect.sync();
        String json = (String)commands.get((Object)key);
        if (json == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(this.objectMapper.readValue(json, clazz));
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

