/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.status.impl;

import com.xforceplus.ultraman.oqsengine.common.lifecycle.Lifecycle;
import com.xforceplus.ultraman.oqsengine.common.map.MapUtils;
import com.xforceplus.ultraman.oqsengine.common.watch.RedisLuaScriptWatchDog;
import com.xforceplus.ultraman.oqsengine.status.CommitIdStatusService;
import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisClient;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.micrometer.core.instrument.Metrics;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitIdStatusServiceImpl
implements CommitIdStatusService,
Lifecycle {
    final Logger logger = LoggerFactory.getLogger(CommitIdStatusServiceImpl.class);
    private static final long DEFAULT_UNKNOWN_LIMIT_NUMBER = 30L;
    private static final String DEFAULT_COMMITIDS_KEY = "com.xforceplus.ultraman.oqsengine.status.commitids";
    private static final String DEFAULT_LAST_OBSOLETE_COMMITID_KEEP = "com.xforceplus.ultraman.oqsengine.status.last.obsolete.keep";
    private static final String DEFAULT_COMMITID_STATUS_KEY_PREFIX = "com.xforceplus.ultraman.oqsengine.status.commitid.";
    private static final String COMMITID_STATUS_UNKNOWN_NUMBER_PREFIX = "com.xforceplus.ultraman.oqsengine.status.commitid.unknown.number.";
    private static String SAVE_LUA_SCRIPT = String.format("local statusKey = KEYS[2]..ARGV[1]local status = redis.call('get', statusKey);if status ~= '%s' then redis.call('set', statusKey, ARGV[2]);redis.call('zadd', KEYS[1], ARGV[1], ARGV[1]);return 1;else return 0;end;", CommitStatus.ELIMINATION.getSymbol());
    private static String OBSOLETE_LUA_SCRIPT = String.format("if (#ARGV == 0) then return false; end; for i=1, #ARGV, 1 do local statusKey = KEYS[2]..ARGV[i]; local unknownKey = KEYS[3]..ARGV[i]; redis.call('del', unknownKey); redis.call('set', statusKey, '%s','EX', %d); redis.call('zrem', KEYS[1], ARGV[i]); end; local keepKey = KEYS[4]; redis.call('set', keepKey, ARGV[#ARGV]); return true;", CommitStatus.ELIMINATION.getSymbol(), 3600);
    private static String FIND_MIN_LUA_SCRIPT = "local unsyncIdsKey = KEYS[1]; local commitdPayload = redis.call('zrange', unsyncIdsKey, 0, 0); local commitdPayload = redis.call('zrange', unsyncIdsKey, 0, 0);if (#commitdPayload == 0) then return redis.call('incrby', KEYS[2], 0);end;local minCommitid = 0; for i = 1, #commitdPayload, 1 do minCommitid = tonumber(commitdPayload[i]); end;if (minCommitid == 0) then return redis.call('incrby', KEYS[2], 0); else return minCommitid; end;";
    @Resource(name="redisClientState")
    private RedisClient redisClient;
    @Resource
    private RedisLuaScriptWatchDog redisLuaScriptWatchDog;
    public Timer timer;
    private StatefulRedisConnection<String, String> syncConnect;
    private RedisCommands<String, String> syncCommands;
    private String commitidsKey;
    private String commitidStatusKeyPrefix;
    private String lastEliminateCommitidKey;
    private String saveLuaScriptSha;
    private String obsoleteLuaScriptSha;
    private String getMinScriptSha;
    private long limitUnknownNumber;
    private AtomicLong unSyncCommitIdSize;
    private AtomicLong unSyncCommitIdMin;
    private AtomicLong unSyncCommitIdMax;

    public CommitIdStatusServiceImpl() {
        this(DEFAULT_COMMITIDS_KEY, DEFAULT_COMMITID_STATUS_KEY_PREFIX, DEFAULT_LAST_OBSOLETE_COMMITID_KEEP);
    }

    public CommitIdStatusServiceImpl(String commitidsKey, String commitIdStatusKeyPreifx, String lastCommitIdKeepKey) {
        this(commitidsKey, commitIdStatusKeyPreifx, lastCommitIdKeepKey, 30L);
    }

    public CommitIdStatusServiceImpl(String commitidsKey, String commitIdStatusKeyPreifx, String lastCommitIdKeepKey, long limitUnknownNumber) {
        this.commitidsKey = commitidsKey;
        if (this.commitidsKey == null || this.commitidsKey.isEmpty()) {
            throw new IllegalArgumentException("The commits key is invalid.");
        }
        this.commitidStatusKeyPrefix = commitIdStatusKeyPreifx;
        if (this.commitidStatusKeyPrefix == null || this.commitidStatusKeyPrefix.isEmpty()) {
            throw new IllegalArgumentException("The commit status key is invalid.");
        }
        this.lastEliminateCommitidKey = lastCommitIdKeepKey;
        if (this.lastEliminateCommitidKey == null || this.lastEliminateCommitidKey.isEmpty()) {
            throw new IllegalArgumentException("The last commit keep key is invalid.");
        }
        this.limitUnknownNumber = limitUnknownNumber;
        long minUnknownNumber = 1L;
        if (this.limitUnknownNumber < 1L) {
            this.limitUnknownNumber = 30L;
        }
    }

    @PostConstruct
    public void init() throws Exception {
        if (this.redisClient == null) {
            throw new IllegalStateException("Invalid redisClient.");
        }
        this.syncConnect = this.redisClient.connect();
        this.syncCommands = this.syncConnect.sync();
        this.syncCommands.clientSetname((Object)"oqs.sync.commitid");
        if (this.redisLuaScriptWatchDog != null) {
            this.saveLuaScriptSha = this.redisLuaScriptWatchDog.watch(SAVE_LUA_SCRIPT);
            this.obsoleteLuaScriptSha = this.redisLuaScriptWatchDog.watch(OBSOLETE_LUA_SCRIPT);
            this.getMinScriptSha = this.redisLuaScriptWatchDog.watch(FIND_MIN_LUA_SCRIPT);
        } else {
            this.saveLuaScriptSha = this.syncCommands.scriptLoad(SAVE_LUA_SCRIPT);
            this.obsoleteLuaScriptSha = this.syncCommands.scriptLoad(OBSOLETE_LUA_SCRIPT);
            this.getMinScriptSha = this.syncCommands.scriptLoad(FIND_MIN_LUA_SCRIPT);
        }
        this.unSyncCommitIdSize = (AtomicLong)Metrics.gauge((String)"oqs.unsync.commitid.count.total", (Number)new AtomicLong(this.size()));
        this.unSyncCommitIdMin = (AtomicLong)Metrics.gauge((String)"oqs.unsync.commitid.min", (Number)new AtomicLong(this.size()));
        this.unSyncCommitIdMax = (AtomicLong)Metrics.gauge((String)"oqs.unsync.commitid.max", (Number)new AtomicLong(this.size()));
        this.logger.info("Use {} as the key for the list of commit Numbers.", (Object)this.commitidsKey);
        this.logger.info("Use {} as the prefix key for the commit number status.", (Object)this.commitidStatusKeyPrefix);
        this.logger.info("Use {} as the prefix key for the commit number status unknown.", (Object)COMMITID_STATUS_UNKNOWN_NUMBER_PREFIX);
        this.timer = new Timer("commit-update-metrics", true);
        this.timer.schedule((TimerTask)new UpdateMetricsTask(), 1000L, 6000L);
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.timer.cancel();
        this.syncConnect.close();
    }

    @Override
    public boolean save(long commitId, boolean ready) {
        if (commitId <= 0L) {
            return false;
        }
        Object[] keys = new String[]{this.commitidsKey, this.commitidStatusKeyPrefix};
        boolean result = (Boolean)this.syncCommands.evalsha(this.saveLuaScriptSha, ScriptOutputType.BOOLEAN, keys, (Object[])new String[]{Long.toString(commitId), ready ? CommitStatus.READY.getSymbol() : CommitStatus.NOT_READY.getSymbol()});
        if (this.logger.isDebugEnabled()) {
            CommitStatus logStatus;
            CommitStatus commitStatus = logStatus = ready ? CommitStatus.READY : CommitStatus.NOT_READY;
            if (result) {
                this.logger.debug("The commit number {} was successfully saved with the status {}.", (Object)commitId, (Object)logStatus.name());
            } else {
                this.logger.debug("The submission number {} is obsolete and will not be saved.", (Object)commitId);
            }
        }
        return result;
    }

    @Override
    public boolean isReady(long commitId) {
        if (commitId <= 0L) {
            this.logger.warn("Invalid COMMITID {}.", (Object)commitId);
            return true;
        }
        CommitStatus status = this.getStatus(commitId);
        if (CommitStatus.READY == status || CommitStatus.ELIMINATION == status) {
            return true;
        }
        if (CommitStatus.UNKNOWN == status) {
            String unknownNumberKey = COMMITID_STATUS_UNKNOWN_NUMBER_PREFIX + commitId;
            long newNumber = this.syncCommands.incr((Object)unknownNumberKey);
            if (newNumber > this.limitUnknownNumber) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("The commit number {} check is always UNKNOWN, the check number reaches the threshold {} and the ready state is automatically changed.", (Object)commitId, (Object)this.limitUnknownNumber);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean[] isReady(long[] commitIds) {
        if (commitIds == null || commitIds.length == 0) {
            return new boolean[0];
        }
        int len = commitIds.length;
        CommitStatus[] commitStatuses = this.getStatus(commitIds);
        boolean[] statues = new boolean[commitStatuses.length];
        for (int i = 0; i < len; ++i) {
            statues[i] = CommitStatus.READY == commitStatuses[i] || CommitStatus.ELIMINATION == commitStatuses[i];
        }
        return statues;
    }

    @Override
    public void ready(long commitId) {
        if (commitId <= 0L) {
            return;
        }
        this.changeStatus(commitId, CommitStatus.READY);
    }

    @Override
    public long[] getUnreadiness() {
        return Arrays.stream(this.getAll()).filter(commitid -> !this.isReady(commitid)).toArray();
    }

    @Override
    public long getMinWithKeep() {
        Object[] keys = new String[]{this.commitidsKey, this.lastEliminateCommitidKey};
        Object value = this.syncCommands.evalsha(this.getMinScriptSha, ScriptOutputType.INTEGER, keys);
        if (value == null) {
            return 0L;
        }
        return (Long)value;
    }

    @Override
    public long getMin() {
        List ids = this.syncCommands.zrange((Object)this.commitidsKey, 0L, 0L);
        if (ids.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("The current minimum commit number not obtained.");
            }
            return 0L;
        }
        return Long.parseLong((String)ids.get(0));
    }

    @Override
    public long getMax() {
        List ids = this.syncCommands.zrevrange((Object)this.commitidsKey, 0L, 0L);
        if (ids.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("The current maximum commit number not obtained.");
            }
            return 0L;
        }
        boolean first = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("The maximum commit number to get to is {}.", ids.get(0));
        }
        return Long.parseLong((String)ids.get(0));
    }

    @Override
    public long[] getAll() {
        List ids = this.syncCommands.zrange((Object)this.commitidsKey, 0L, -1L);
        return ids.parallelStream().mapToLong(id -> Long.parseLong(id)).toArray();
    }

    @Override
    public long size() {
        return this.syncCommands.zcard((Object)this.commitidsKey);
    }

    @Override
    public void obsolete(long ... commitIds) {
        if (commitIds.length == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No submission number needs to be eliminated.");
            }
            return;
        }
        Object[] keys = new String[]{this.commitidsKey, this.commitidStatusKeyPrefix, COMMITID_STATUS_UNKNOWN_NUMBER_PREFIX, this.lastEliminateCommitidKey};
        Object[] ids = (String[])Arrays.stream(commitIds).sorted().mapToObj(commitId -> Long.toString(commitId)).toArray(String[]::new);
        this.syncCommands.evalsha(this.obsoleteLuaScriptSha, ScriptOutputType.BOOLEAN, keys, ids);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("The commit`s number {} has been eliminated.", (Object)Arrays.toString(commitIds));
        }
    }

    @Override
    public void obsoleteAll() {
        this.obsolete(this.getAll());
    }

    @Override
    public boolean isObsolete(long commitId) {
        CommitStatus status = this.getStatus(commitId);
        return CommitStatus.ELIMINATION == status || CommitStatus.UNKNOWN == status;
    }

    public void setLimitUnknownNumber(long limitUnknownNumber) {
        this.limitUnknownNumber = limitUnknownNumber;
    }

    private CommitStatus getStatus(long commitId) {
        String statusKey = String.format("%s%d", this.commitidStatusKeyPrefix, commitId);
        String value = (String)this.syncCommands.get((Object)statusKey);
        CommitStatus status = CommitStatus.getInstance(value);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Check that the status of the commit number {} is {}.", (Object)commitId, (Object)status.name());
        }
        return status;
    }

    private CommitStatus[] getStatus(long[] commitIds) {
        int len = commitIds.length;
        if (len == 0) {
            return new CommitStatus[0];
        }
        Object[] keys = (String[])Arrays.stream(commitIds).mapToObj(c -> String.format("%s%d", this.commitidStatusKeyPrefix, c)).toArray(String[]::new);
        HashMap<String, Integer> keyPos = new HashMap<String, Integer>(MapUtils.calculateInitSize((int)len));
        for (int i = 0; i < len; ++i) {
            keyPos.put(keys[i], i);
        }
        List keyValues = this.syncCommands.mget(keys);
        CommitStatus[] statuses = new CommitStatus[len];
        for (int i = 0; i < keyValues.size(); ++i) {
            KeyValue kv = (KeyValue)keyValues.get(i);
            int pos = (Integer)keyPos.get(kv.getKey());
            statuses[pos] = kv.hasValue() ? CommitStatus.getInstance((String)kv.getValue()) : CommitStatus.READY;
        }
        return statuses;
    }

    private void changeStatus(long commitId, CommitStatus status) {
        String statusKey = this.commitidStatusKeyPrefix + commitId;
        this.syncCommands.set((Object)statusKey, (Object)status.getSymbol());
    }

    private class UpdateMetricsTask
    extends TimerTask {
        private UpdateMetricsTask() {
        }

        @Override
        public void run() {
            try {
                CommitIdStatusServiceImpl.this.unSyncCommitIdSize.set(CommitIdStatusServiceImpl.this.size());
                long commitId = CommitIdStatusServiceImpl.this.getMin();
                CommitIdStatusServiceImpl.this.unSyncCommitIdMin.set(commitId);
                commitId = CommitIdStatusServiceImpl.this.getMax();
                CommitIdStatusServiceImpl.this.unSyncCommitIdMax.set(commitId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static enum CommitStatus {
        UNKNOWN("U"),
        NOT_READY("N"),
        READY("R"),
        ELIMINATION("E");

        private String symbol;

        public String getSymbol() {
            return this.symbol;
        }

        private CommitStatus(String symbol) {
            this.symbol = symbol;
        }

        public static CommitStatus getInstance(String symbol) {
            for (CommitStatus status : CommitStatus.values()) {
                if (!status.getSymbol().equals(symbol)) continue;
                return status;
            }
            return UNKNOWN;
        }
    }
}

