/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.tokenizer;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import java.util.Iterator;

public interface Tokenizer {
    default public Iterator<String> tokenize(String value) {
        return this.tokenize(value, TokenizerMode.SEARCH);
    }

    public Iterator<String> tokenize(String var1, TokenizerMode var2);

    public FieldConfig.FuzzyType support();

    public static enum TokenizerMode {
        UNKNOWN(0),
        SEARCH(1),
        STORAGE(2);

        private int symbol;

        private TokenizerMode(int symbol) {
            this.symbol = symbol;
        }

        public int getSymbol() {
            return this.symbol;
        }

        public static TokenizerMode getInstance(int symbol) {
            for (TokenizerMode mode : TokenizerMode.values()) {
                if (mode.getSymbol() != symbol) continue;
                return mode;
            }
            return UNKNOWN;
        }
    }
}

