/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.tokenizer;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.tokenizer.Tokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class WrapperTokenizer
implements Tokenizer {
    private Collection<Tokenizer> tokenizers;
    private FieldConfig.FuzzyType type;

    public WrapperTokenizer(Collection<Tokenizer> tokenizers, FieldConfig.FuzzyType type) {
        this.tokenizers = tokenizers;
        this.type = type;
    }

    @Override
    public Iterator<String> tokenize(String value, Tokenizer.TokenizerMode mode) {
        return new WrapperIterator(this.tokenizers, value, mode);
    }

    @Override
    public FieldConfig.FuzzyType support() {
        return this.type;
    }

    static class WrapperIterator
    implements Iterator<String> {
        private List<Tokenizer> tokenizers;
        private Tokenizer.TokenizerMode mode;
        private Iterator<String> currentIter;
        private String value;

        public WrapperIterator(Collection<Tokenizer> tokenizers, String value, Tokenizer.TokenizerMode mode) {
            this.tokenizers = new ArrayList<Tokenizer>(tokenizers);
            this.value = value;
            this.mode = mode;
            if (!tokenizers.isEmpty()) {
                this.currentIter = this.tokenizers.remove(0).tokenize(this.value);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.currentIter.hasNext()) {
                return true;
            }
            do {
                if (this.tokenizers.isEmpty()) {
                    return false;
                }
                Tokenizer tokenizer = this.tokenizers.remove(0);
                this.currentIter = tokenizer.tokenize(this.value, this.mode);
            } while (!this.currentIter.hasNext());
            return true;
        }

        @Override
        public String next() {
            return this.currentIter.next();
        }
    }
}

