/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.tokenizer;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.IEntityField;
import com.xforceplus.ultraman.oqsengine.tokenizer.NothingTokenizer;
import com.xforceplus.ultraman.oqsengine.tokenizer.Tokenizer;
import com.xforceplus.ultraman.oqsengine.tokenizer.TokenizerFactory;
import com.xforceplus.ultraman.oqsengine.tokenizer.UnsupportTokenizer;
import com.xforceplus.ultraman.oqsengine.tokenizer.WrapperTokenizer;
import com.xforceplus.ultraman.oqsengine.tokenizer.segmentation.JcsegTokenizer;
import com.xforceplus.ultraman.oqsengine.tokenizer.wildcard.WildcardTokenizer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultTokenizerFactory
implements TokenizerFactory {
    private ConcurrentMap<Integer, WildcardTokenizer> wildcardTokenizerCache = new ConcurrentHashMap<Integer, WildcardTokenizer>();
    private Tokenizer segmentationTokenizer;

    public DefaultTokenizerFactory() throws IOException {
        this.segmentationTokenizer = new JcsegTokenizer();
    }

    public DefaultTokenizerFactory(URL lexUrl) throws IOException {
        this.segmentationTokenizer = new JcsegTokenizer(lexUrl);
    }

    public DefaultTokenizerFactory(File lexDir) throws IOException {
        this.segmentationTokenizer = new JcsegTokenizer(lexDir);
    }

    @Override
    public Tokenizer getTokenizer(IEntityField field) {
        FieldConfig.FuzzyType type = field.config().getFuzzyType();
        switch (type) {
            case WILDCARD: {
                int min = field.config().getWildcardMinWidth();
                int max = field.config().getWildcardMaxWidth();
                return this.findWildcardTokenizer(min, max);
            }
            case SEGMENTATION: {
                return this.segmentationTokenizer;
            }
            case NOT: {
                return NothingTokenizer.getInstance();
            }
        }
        return UnsupportTokenizer.getInstance();
    }

    @Override
    public Tokenizer getWildcardTokenizer(int min, int max) {
        return this.findWildcardTokenizer(min, max);
    }

    @Override
    public Tokenizer getSegmentationTokenizer() {
        return this.segmentationTokenizer;
    }

    public Map<Integer, WildcardTokenizer> getWildcardTokenizerCache() {
        return new HashMap<Integer, WildcardTokenizer>(this.wildcardTokenizerCache);
    }

    private Tokenizer findWildcardTokenizer(int min, int max) {
        ArrayList<Tokenizer> tokenizers = new ArrayList<Tokenizer>(max - min);
        for (int i = min; i <= max; ++i) {
            tokenizers.add(this.wildcardTokenizerCache.computeIfAbsent(i, k -> new WildcardTokenizer((int)k)));
        }
        return new WrapperTokenizer(tokenizers, FieldConfig.FuzzyType.WILDCARD);
    }
}

