/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.oqsengine.tokenizer.wildcard;

import com.xforceplus.ultraman.oqsengine.pojo.dto.entity.FieldConfig;
import com.xforceplus.ultraman.oqsengine.tokenizer.EmptyWorkdsIterator;
import com.xforceplus.ultraman.oqsengine.tokenizer.Tokenizer;
import java.util.Iterator;
import java.util.Objects;

public class WildcardTokenizer
implements Tokenizer {
    private static final int DEFAULT_WIDTH = 3;
    private int width;

    public WildcardTokenizer() {
        this(3);
    }

    public WildcardTokenizer(int width) {
        this.width = width;
        if (this.width < 3) {
            throw new IllegalArgumentException(String.format("The maximum segment length is %d.", 3));
        }
    }

    @Override
    public Iterator<String> tokenize(String value, Tokenizer.TokenizerMode mode) {
        if (value == null || value.length() < this.width) {
            return EmptyWorkdsIterator.getInstance();
        }
        return new WordsIterator(this.width, value);
    }

    @Override
    public FieldConfig.FuzzyType support() {
        return FieldConfig.FuzzyType.WILDCARD;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WildcardTokenizer)) {
            return false;
        }
        WildcardTokenizer that = (WildcardTokenizer)o;
        return this.width == that.width;
    }

    public int hashCode() {
        return Objects.hash(this.width);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WildcardTokenizer{");
        sb.append("width=").append(this.width);
        sb.append('}');
        return sb.toString();
    }

    private static int calculateTotalWords(String value, int width) {
        return value.length() - (width - 1);
    }

    private static class WordsIterator
    implements Iterator<String> {
        private String value;
        private int currentPoint;
        private int useWordNumber;
        private int width;
        private int totalWords;
        private char[] buff;

        public WordsIterator(int width, String value) {
            this.width = width;
            this.buff = new char[width];
            this.useWordNumber = 0;
            this.currentPoint = 0;
            this.totalWords = WildcardTokenizer.calculateTotalWords(value, width);
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.useWordNumber < this.totalWords;
        }

        @Override
        public String next() {
            for (int i = 0; i < this.width; ++i) {
                this.buff[i] = this.value.charAt(this.currentPoint + i);
            }
            ++this.useWordNumber;
            ++this.currentPoint;
            return new String(this.buff);
        }
    }
}

