package com.xforceplus.ultramanfortest.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 交通灯
 * </p>
 *
 * @author ultraman
 * @since 2021-06-28
 */
public enum Traficlight {

    EE("ee", "eee"),
    KEY("key", "value"),
    AFD("afd", "sdf");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    Traficlight(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Traficlight fromCode(String code){
        switch(code) {
            case "ee":
                return EE;
            case "key":
                return KEY;
            case "afd":
                return AFD;
            default:
                return null;
        }
    }
}
