package com.xforceplus.ultramanfortest.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2021-06-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Invoice implements Serializable {

  private static final long serialVersionUID=1L;

  @TableField("invoiceNo")
  private String invoiceNo;

  @TableField("invoiceCode")
  private String invoiceCode;

  @TableField("sellerName")
  private String sellerName;

  private Long id;

  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  @TableField("stingSetTest")
  private String stingSetTest;

  @TableField("numTest")
  private Long numTest;

  @TableField("intTest")
  private Long intTest;

  @TableField("floatTest")
  private BigDecimal floatTest;

  @TableField("boolTest")
  private Boolean boolTest;

  @TableField("timeTest")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime timeTest;

  @TableField("enumTest")
  private String enumTest;

  private String qw;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("sellerName", sellerName);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("stingSetTest", stingSetTest);
      map.put("numTest", numTest);
      map.put("intTest", intTest);
      map.put("floatTest", floatTest);
      map.put("boolTest", boolTest);
      map.put("timeTest", BocpGenUtils.toTimestamp(timeTest));
      map.put("enumTest", enumTest);
      map.put("qw", qw);
      return map;
  }

  public static Invoice fromOQSMap(Map map){
    if(map == null) {
      return null;
    }
    Invoice entity = new Invoice();
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stingSetTest")) {
      Object obj = map.get("stingSetTest");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStingSetTest((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("numTest")) {
      Object obj = map.get("numTest");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setNumTest((Long)obj);
        } else if(obj instanceof String) {
          entity.setNumTest(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setNumTest(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("intTest")) {
      Object obj = map.get("intTest");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIntTest((Long)obj);
        } else if(obj instanceof String) {
          entity.setIntTest(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setIntTest(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("floatTest")) {
      Object obj = map.get("floatTest");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFloatTest((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFloatTest(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFloatTest(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setFloatTest(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFloatTest(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("boolTest")) {
      Object obj = map.get("boolTest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBoolTest((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setBoolTest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("timeTest")) {
      Object obj = map.get("timeTest");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTimeTest(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setTimeTest((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setTimeTest(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTimeTest(null);
      }
    }
    if(map.containsKey("enumTest")) {
      Object obj = map.get("enumTest");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEnumTest((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qw")) {
      Object obj = map.get("qw");
      if(obj != null) {
        if(obj instanceof String){
          entity.setQw((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
