package com.xforceplus.ultramanfortest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanfortest.entity.Extandstest;
import com.xforceplus.ultramanfortest.service.IExtandstestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-07
 */
@RestController
public class ExtandstestController {

  @Autowired
  private IExtandstestService extandstestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param extandstest ${table.comment}
   * @return
   */
  @GetMapping("/extandstests" )
  public XfR getExtandstests(XfPage page, Extandstest extandstest) {
    return XfR.ok(extandstestServiceImpl.page(page, Wrappers.query(extandstest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/extandstests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(extandstestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param extandstest ${table.comment}
   * @return XfR
   */
  @PostMapping("/extandstests")
  public XfR save(@RequestBody Extandstest extandstest) {
     return XfR.ok(extandstestServiceImpl.save(extandstest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param extandstest ${table.comment}
   * @return XfR
   */
  @PutMapping("/extandstests/{id}")
  public XfR putUpdate(@RequestBody Extandstest extandstest,@PathVariable Long id) {
      extandstest.setId(id);
      return XfR.ok(extandstestServiceImpl.updateById(extandstest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param extandstest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/extandstests/{id}")
  public XfR patchUpdate(@RequestBody Extandstest extandstest,@PathVariable Long id) {
      Extandstest upextandstest = extandstestServiceImpl.getById(id);
      if(upextandstest != null){
        upextandstest = ObjectCopyUtils.copyProperties(extandstest,upextandstest,true);
      }
      return XfR.ok(extandstestServiceImpl.updateById(upextandstest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/extandstests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(extandstestServiceImpl.removeById(id));
  }

  @PostMapping("/extandstests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "extandstest");
     params.put("request", condition);

     return XfR.ok(extandstestServiceImpl.querys(params));
  }

}
