package com.xforceplus.ultramanfortest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanfortest.entity.Uiautotest;
import com.xforceplus.ultramanfortest.service.IUiautotestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-07
 */
@RestController
public class UiautotestController {

  @Autowired
  private IUiautotestService uiautotestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param uiautotest ${table.comment}
   * @return
   */
  @GetMapping("/uiautotests" )
  public XfR getUiautotests(XfPage page, Uiautotest uiautotest) {
    return XfR.ok(uiautotestServiceImpl.page(page, Wrappers.query(uiautotest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/uiautotests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(uiautotestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param uiautotest ${table.comment}
   * @return XfR
   */
  @PostMapping("/uiautotests")
  public XfR save(@RequestBody Uiautotest uiautotest) {
     return XfR.ok(uiautotestServiceImpl.save(uiautotest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param uiautotest ${table.comment}
   * @return XfR
   */
  @PutMapping("/uiautotests/{id}")
  public XfR putUpdate(@RequestBody Uiautotest uiautotest,@PathVariable Long id) {
      uiautotest.setId(id);
      return XfR.ok(uiautotestServiceImpl.updateById(uiautotest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param uiautotest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/uiautotests/{id}")
  public XfR patchUpdate(@RequestBody Uiautotest uiautotest,@PathVariable Long id) {
      Uiautotest upuiautotest = uiautotestServiceImpl.getById(id);
      if(upuiautotest != null){
        upuiautotest = ObjectCopyUtils.copyProperties(uiautotest,upuiautotest,true);
      }
      return XfR.ok(uiautotestServiceImpl.updateById(upuiautotest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/uiautotests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(uiautotestServiceImpl.removeById(id));
  }

  @PostMapping("/uiautotests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "uiautotest");
     params.put("request", condition);

     return XfR.ok(uiautotestServiceImpl.querys(params));
  }

}
