package com.xforceplus.ultramanfortest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanfortest.entity.Ziguanlian;
import com.xforceplus.ultramanfortest.service.IZiguanlianService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-07
 */
@RestController
public class ZiguanlianController {

  @Autowired
  private IZiguanlianService ziguanlianServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ziguanlian ${table.comment}
   * @return
   */
  @GetMapping("/ziguanlians" )
  public XfR getZiguanlians(XfPage page, Ziguanlian ziguanlian) {
    return XfR.ok(ziguanlianServiceImpl.page(page, Wrappers.query(ziguanlian)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ziguanlians/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ziguanlianServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ziguanlian ${table.comment}
   * @return XfR
   */
  @PostMapping("/ziguanlians")
  public XfR save(@RequestBody Ziguanlian ziguanlian) {
     return XfR.ok(ziguanlianServiceImpl.save(ziguanlian));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ziguanlian ${table.comment}
   * @return XfR
   */
  @PutMapping("/ziguanlians/{id}")
  public XfR putUpdate(@RequestBody Ziguanlian ziguanlian,@PathVariable Long id) {
      ziguanlian.setId(id);
      return XfR.ok(ziguanlianServiceImpl.updateById(ziguanlian));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ziguanlian ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ziguanlians/{id}")
  public XfR patchUpdate(@RequestBody Ziguanlian ziguanlian,@PathVariable Long id) {
      Ziguanlian upziguanlian = ziguanlianServiceImpl.getById(id);
      if(upziguanlian != null){
        upziguanlian = ObjectCopyUtils.copyProperties(ziguanlian,upziguanlian,true);
      }
      return XfR.ok(ziguanlianServiceImpl.updateById(upziguanlian));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ziguanlians/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ziguanlianServiceImpl.removeById(id));
  }

  @PostMapping("/ziguanlians/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ziguanlian");
     params.put("request", condition);

     return XfR.ok(ziguanlianServiceImpl.querys(params));
  }

}
