package com.xforceplus.ultramanfortest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanfortest.entity.Ziguanlianzilei;
import com.xforceplus.ultramanfortest.service.IZiguanlianzileiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-07
 */
@RestController
public class ZiguanlianzileiController {

  @Autowired
  private IZiguanlianzileiService ziguanlianzileiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ziguanlianzilei ${table.comment}
   * @return
   */
  @GetMapping("/ziguanlianzileis" )
  public XfR getZiguanlianzileis(XfPage page, Ziguanlianzilei ziguanlianzilei) {
    return XfR.ok(ziguanlianzileiServiceImpl.page(page, Wrappers.query(ziguanlianzilei)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ziguanlianzileis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ziguanlianzileiServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ziguanlianzilei ${table.comment}
   * @return XfR
   */
  @PostMapping("/ziguanlianzileis")
  public XfR save(@RequestBody Ziguanlianzilei ziguanlianzilei) {
     return XfR.ok(ziguanlianzileiServiceImpl.save(ziguanlianzilei));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ziguanlianzilei ${table.comment}
   * @return XfR
   */
  @PutMapping("/ziguanlianzileis/{id}")
  public XfR putUpdate(@RequestBody Ziguanlianzilei ziguanlianzilei,@PathVariable Long id) {
      ziguanlianzilei.setId(id);
      return XfR.ok(ziguanlianzileiServiceImpl.updateById(ziguanlianzilei));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ziguanlianzilei ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ziguanlianzileis/{id}")
  public XfR patchUpdate(@RequestBody Ziguanlianzilei ziguanlianzilei,@PathVariable Long id) {
      Ziguanlianzilei upziguanlianzilei = ziguanlianzileiServiceImpl.getById(id);
      if(upziguanlianzilei != null){
        upziguanlianzilei = ObjectCopyUtils.copyProperties(ziguanlianzilei,upziguanlianzilei,true);
      }
      return XfR.ok(ziguanlianzileiServiceImpl.updateById(upziguanlianzilei));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ziguanlianzileis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ziguanlianzileiServiceImpl.removeById(id));
  }

  @PostMapping("/ziguanlianzileis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ziguanlianzilei");
     params.put("request", condition);

     return XfR.ok(ziguanlianzileiServiceImpl.querys(params));
  }

}
