package com.xforceplus.ultramanfortest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanfortest.entity.Newinvoice;
import com.xforceplus.ultramanfortest.service.INewinvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-05-19
 */
@RestController
public class NewinvoiceController {

  @Autowired
  private INewinvoiceService newinvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param newinvoice ${table.comment}
   * @return
   */
  @GetMapping("/newinvoices" )
  public XfR getNewinvoices(XfPage page, Newinvoice newinvoice) {
    return XfR.ok(newinvoiceServiceImpl.page(page, Wrappers.query(newinvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/newinvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(newinvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param newinvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/newinvoices")
  public XfR save(@RequestBody Newinvoice newinvoice) {
     return XfR.ok(newinvoiceServiceImpl.save(newinvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param newinvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/newinvoices/{id}")
  public XfR putUpdate(@RequestBody Newinvoice newinvoice,@PathVariable Long id) {
      newinvoice.setId(id);
      return XfR.ok(newinvoiceServiceImpl.updateById(newinvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param newinvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/newinvoices/{id}")
  public XfR patchUpdate(@RequestBody Newinvoice newinvoice,@PathVariable Long id) {
      Newinvoice upnewinvoice = newinvoiceServiceImpl.getById(id);
      if(upnewinvoice != null){
        upnewinvoice = ObjectCopyUtils.copyProperties(newinvoice,upnewinvoice,true);
      }
      return XfR.ok(newinvoiceServiceImpl.updateById(upnewinvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/newinvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(newinvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/newinvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "newinvoice");
     params.put("request", condition);

     return XfR.ok(newinvoiceServiceImpl.querys(params));
  }

}
