package com.xforceplus.ultramanfortest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanfortest.entity.Copytest;
import com.xforceplus.ultramanfortest.service.ICopytestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-09
 */
@RestController
public class CopytestController {

  @Autowired
  private ICopytestService copytestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param copytest ${table.comment}
   * @return
   */
  @GetMapping("/copytests" )
  public XfR getCopytests(XfPage page, Copytest copytest) {
    return XfR.ok(copytestServiceImpl.page(page, Wrappers.query(copytest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/copytests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(copytestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param copytest ${table.comment}
   * @return XfR
   */
  @PostMapping("/copytests")
  public XfR save(@RequestBody Copytest copytest) {
     return XfR.ok(copytestServiceImpl.save(copytest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param copytest ${table.comment}
   * @return XfR
   */
  @PutMapping("/copytests/{id}")
  public XfR putUpdate(@RequestBody Copytest copytest,@PathVariable Long id) {
      copytest.setId(id);
      return XfR.ok(copytestServiceImpl.updateById(copytest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param copytest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/copytests/{id}")
  public XfR patchUpdate(@RequestBody Copytest copytest,@PathVariable Long id) {
      Copytest upcopytest = copytestServiceImpl.getById(id);
      if(upcopytest != null){
        upcopytest = ObjectCopyUtils.copyProperties(copytest,upcopytest,true);
      }
      return XfR.ok(copytestServiceImpl.updateById(upcopytest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/copytests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(copytestServiceImpl.removeById(id));
  }

  @PostMapping("/copytests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "copytest");
     params.put("request", condition);

     return XfR.ok(copytestServiceImpl.querys(params));
  }

}
