package com.xforceplus.ultramanfortest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanfortest.entity.Invoicedetailsnew;
import com.xforceplus.ultramanfortest.service.IInvoicedetailsnewService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-09
 */
@RestController
public class InvoicedetailsnewController {

  @Autowired
  private IInvoicedetailsnewService invoicedetailsnewServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoicedetailsnew ${table.comment}
   * @return
   */
  @GetMapping("/invoicedetailsnews" )
  public XfR getInvoicedetailsnews(XfPage page, Invoicedetailsnew invoicedetailsnew) {
    return XfR.ok(invoicedetailsnewServiceImpl.page(page, Wrappers.query(invoicedetailsnew)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicedetailsnews/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoicedetailsnewServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoicedetailsnew ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicedetailsnews")
  public XfR save(@RequestBody Invoicedetailsnew invoicedetailsnew) {
     return XfR.ok(invoicedetailsnewServiceImpl.save(invoicedetailsnew));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoicedetailsnew ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicedetailsnews/{id}")
  public XfR putUpdate(@RequestBody Invoicedetailsnew invoicedetailsnew,@PathVariable Long id) {
      invoicedetailsnew.setId(id);
      return XfR.ok(invoicedetailsnewServiceImpl.updateById(invoicedetailsnew));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoicedetailsnew ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicedetailsnews/{id}")
  public XfR patchUpdate(@RequestBody Invoicedetailsnew invoicedetailsnew,@PathVariable Long id) {
      Invoicedetailsnew upinvoicedetailsnew = invoicedetailsnewServiceImpl.getById(id);
      if(upinvoicedetailsnew != null){
        upinvoicedetailsnew = ObjectCopyUtils.copyProperties(invoicedetailsnew,upinvoicedetailsnew,true);
      }
      return XfR.ok(invoicedetailsnewServiceImpl.updateById(upinvoicedetailsnew));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicedetailsnews/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoicedetailsnewServiceImpl.removeById(id));
  }

  @PostMapping("/invoicedetailsnews/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoicedetailsnew");
     params.put("request", condition);

     return XfR.ok(invoicedetailsnewServiceImpl.querys(params));
  }

}
