package com.xforceplus.ultramanfortest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanfortest.entity.Runtimeexceptiontest;
import com.xforceplus.ultramanfortest.service.IRuntimeexceptiontestService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-09
 */
@RestController
public class RuntimeexceptiontestController {

  @Autowired
  private IRuntimeexceptiontestService runtimeexceptiontestServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param runtimeexceptiontest ${table.comment}
   * @return
   */
  @GetMapping("/runtimeexceptiontests" )
  public XfR getRuntimeexceptiontests(XfPage page, Runtimeexceptiontest runtimeexceptiontest) {
    return XfR.ok(runtimeexceptiontestServiceImpl.page(page, Wrappers.query(runtimeexceptiontest)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/runtimeexceptiontests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(runtimeexceptiontestServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param runtimeexceptiontest ${table.comment}
   * @return XfR
   */
  @PostMapping("/runtimeexceptiontests")
  public XfR save(@RequestBody Runtimeexceptiontest runtimeexceptiontest) {
     return XfR.ok(runtimeexceptiontestServiceImpl.save(runtimeexceptiontest));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param runtimeexceptiontest ${table.comment}
   * @return XfR
   */
  @PutMapping("/runtimeexceptiontests/{id}")
  public XfR putUpdate(@RequestBody Runtimeexceptiontest runtimeexceptiontest,@PathVariable Long id) {
      runtimeexceptiontest.setId(id);
      return XfR.ok(runtimeexceptiontestServiceImpl.updateById(runtimeexceptiontest));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param runtimeexceptiontest ${table.comment}
   * @return XfR
   */
  @PatchMapping("/runtimeexceptiontests/{id}")
  public XfR patchUpdate(@RequestBody Runtimeexceptiontest runtimeexceptiontest,@PathVariable Long id) {
      Runtimeexceptiontest upruntimeexceptiontest = runtimeexceptiontestServiceImpl.getById(id);
      if(upruntimeexceptiontest != null){
        upruntimeexceptiontest = ObjectCopyUtils.copyProperties(runtimeexceptiontest,upruntimeexceptiontest,true);
      }
      return XfR.ok(runtimeexceptiontestServiceImpl.updateById(upruntimeexceptiontest));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/runtimeexceptiontests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(runtimeexceptiontestServiceImpl.removeById(id));
  }

  @PostMapping("/runtimeexceptiontests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "runtimeexceptiontest");
     params.put("request", condition);

     return XfR.ok(runtimeexceptiontestServiceImpl.querys(params));
  }

}
