package com.xforceplus.ultramanfortest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanfortest.entity.Testnull;
import com.xforceplus.ultramanfortest.service.ITestnullService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-09
 */
@RestController
public class TestnullController {

  @Autowired
  private ITestnullService testnullServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testnull ${table.comment}
   * @return
   */
  @GetMapping("/testnulls" )
  public XfR getTestnulls(XfPage page, Testnull testnull) {
    return XfR.ok(testnullServiceImpl.page(page, Wrappers.query(testnull)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testnulls/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testnullServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testnull ${table.comment}
   * @return XfR
   */
  @PostMapping("/testnulls")
  public XfR save(@RequestBody Testnull testnull) {
     return XfR.ok(testnullServiceImpl.save(testnull));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testnull ${table.comment}
   * @return XfR
   */
  @PutMapping("/testnulls/{id}")
  public XfR putUpdate(@RequestBody Testnull testnull,@PathVariable Long id) {
      testnull.setId(id);
      return XfR.ok(testnullServiceImpl.updateById(testnull));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testnull ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testnulls/{id}")
  public XfR patchUpdate(@RequestBody Testnull testnull,@PathVariable Long id) {
      Testnull uptestnull = testnullServiceImpl.getById(id);
      if(uptestnull != null){
        uptestnull = ObjectCopyUtils.copyProperties(testnull,uptestnull,true);
      }
      return XfR.ok(testnullServiceImpl.updateById(uptestnull));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testnulls/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testnullServiceImpl.removeById(id));
  }

  @PostMapping("/testnulls/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testnull");
     params.put("request", condition);

     return XfR.ok(testnullServiceImpl.querys(params));
  }

}
