package com.xforceplus.ultramanfortest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultramanfortest.entity.Zuhuceshi;
import com.xforceplus.ultramanfortest.service.IZuhuceshiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-09
 */
@RestController
public class ZuhuceshiController {

  @Autowired
  private IZuhuceshiService zuhuceshiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zuhuceshi ${table.comment}
   * @return
   */
  @GetMapping("/zuhuceshis" )
  public XfR getZuhuceshis(XfPage page, Zuhuceshi zuhuceshi) {
    return XfR.ok(zuhuceshiServiceImpl.page(page, Wrappers.query(zuhuceshi)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/zuhuceshis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zuhuceshiServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param zuhuceshi ${table.comment}
   * @return XfR
   */
  @PostMapping("/zuhuceshis")
  public XfR save(@RequestBody Zuhuceshi zuhuceshi) {
     return XfR.ok(zuhuceshiServiceImpl.save(zuhuceshi));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param zuhuceshi ${table.comment}
   * @return XfR
   */
  @PutMapping("/zuhuceshis/{id}")
  public XfR putUpdate(@RequestBody Zuhuceshi zuhuceshi,@PathVariable Long id) {
      zuhuceshi.setId(id);
      return XfR.ok(zuhuceshiServiceImpl.updateById(zuhuceshi));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param zuhuceshi ${table.comment}
   * @return XfR
   */
  @PatchMapping("/zuhuceshis/{id}")
  public XfR patchUpdate(@RequestBody Zuhuceshi zuhuceshi,@PathVariable Long id) {
      Zuhuceshi upzuhuceshi = zuhuceshiServiceImpl.getById(id);
      if(upzuhuceshi != null){
        upzuhuceshi = ObjectCopyUtils.copyProperties(zuhuceshi,upzuhuceshi,true);
      }
      return XfR.ok(zuhuceshiServiceImpl.updateById(upzuhuceshi));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zuhuceshis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zuhuceshiServiceImpl.removeById(id));
  }

  @PostMapping("/zuhuceshis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zuhuceshi");
     params.put("request", condition);

     return XfR.ok(zuhuceshiServiceImpl.querys(params));
  }

}
