package com.xforceplus.unicharm.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.unicharm.entity.DiscountProcess;
import com.xforceplus.unicharm.service.IDiscountProcessService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-11
 */
@RestController
public class DiscountProcessController {

  @Autowired
  private IDiscountProcessService discountProcessServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param discountProcess ${table.comment}
   * @return
   */
  @GetMapping("/discountprocesss" )
  public XfR getDiscountProcesss(XfPage page, DiscountProcess discountProcess) {
    return XfR.ok(discountProcessServiceImpl.page(page, Wrappers.query(discountProcess)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/discountprocesss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(discountProcessServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param discountProcess ${table.comment}
   * @return XfR
   */
  @PostMapping("/discountprocesss")
  public XfR save(@RequestBody DiscountProcess discountProcess) {
     return XfR.ok(discountProcessServiceImpl.save(discountProcess));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param discountProcess ${table.comment}
   * @return XfR
   */
  @PutMapping("/discountprocesss/{id}")
  public XfR putUpdate(@RequestBody DiscountProcess discountProcess,@PathVariable Long id) {
      discountProcess.setId(id);
      return XfR.ok(discountProcessServiceImpl.updateById(discountProcess));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param discountProcess ${table.comment}
   * @return XfR
   */
  @PatchMapping("/discountprocesss/{id}")
  public XfR patchUpdate(@RequestBody DiscountProcess discountProcess,@PathVariable Long id) {
      DiscountProcess updiscountProcess = discountProcessServiceImpl.getById(id);
      if(updiscountProcess != null){
        updiscountProcess = ObjectCopyUtils.copyProperties(discountProcess,updiscountProcess,true);
      }
      return XfR.ok(discountProcessServiceImpl.updateById(updiscountProcess));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/discountprocesss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(discountProcessServiceImpl.removeById(id));
  }

  @PostMapping("/discountprocesss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "discount_process");
     params.put("request", condition);

     return XfR.ok(discountProcessServiceImpl.querys(params));
  }

}
